// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AMRStitchCellPluginInfo.C
// ****************************************************************************

#include <AMRStitchCellPluginInfo.h>
#include <AMRStitchCellAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(AMRStitchCell,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(AMRStitchCell,General)

// ****************************************************************************
//  Method: AMRStitchCellGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AMRStitchCellGeneralPluginInfo::GetName() const
{
    return "AMRStitchCell";
}

// ****************************************************************************
//  Method: AMRStitchCellGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AMRStitchCellGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: AMRStitchCellGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AMRStitchCellGeneralPluginInfo::GetID() const
{
    return "AMRStitchCell_1.0";
}
// ****************************************************************************
//  Method: AMRStitchCellGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
AMRStitchCellGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: AMRStitchCellGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AMRStitchCellGeneralPluginInfo::GetCategoryName() const
{
    return "Geometry";
}
