// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AMRStitchCellGUIPluginInfo.C
// ****************************************************************************

#include <AMRStitchCellPluginInfo.h>
#include <AMRStitchCellAttributes.h>
#include <QApplication>
#include <QvisAMRStitchCellWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(AMRStitchCell,GUI)

// ****************************************************************************
//  Method: AMRStitchCellGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
AMRStitchCellGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "AMR Dual Grid and Stitch Cells"));
}


// ****************************************************************************
//  Method: AMRStitchCellGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
AMRStitchCellGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisAMRStitchCellWindow(type, (AMRStitchCellAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: AMRStitchCellGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <AMRStitchCell.xpm>
const char **
AMRStitchCellGUIPluginInfo::XPMIconData() const
{
    return AMRStitchCell_xpm;
}

