// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AMRStitchCellCommonPluginInfo.C
// ****************************************************************************

#include <AMRStitchCellPluginInfo.h>
#include <AMRStitchCellAttributes.h>

// ****************************************************************************
//  Method: AMRStitchCellCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AMRStitchCellCommonPluginInfo::AllocAttributes()
{
    return new AMRStitchCellAttributes;
}

// ****************************************************************************
//  Method: AMRStitchCellCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a AMRStitchCell attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AMRStitchCellCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((AMRStitchCellAttributes *) to) = *((AMRStitchCellAttributes *) from);
}
