// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: AMRStitchCellAttributes
//
// Purpose:
//    Attributes for Stitch Cell Operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class AMRStitchCellAttributes extends AttributeSubject implements Plugin
{
    private static int AMRStitchCellAttributes_numAdditionalAtts = 1;

    // Enum values
    public final static int CREATETYPE_DUALGRIDANDSTITCHCELLS = 0;
    public final static int CREATETYPE_DUALGRID = 1;
    public final static int CREATETYPE_STITCHCELLS = 2;


    public AMRStitchCellAttributes()
    {
        super(AMRStitchCellAttributes_numAdditionalAtts);

        CreateCellsOfType = CREATETYPE_DUALGRIDANDSTITCHCELLS;
    }

    public AMRStitchCellAttributes(int nMoreFields)
    {
        super(AMRStitchCellAttributes_numAdditionalAtts + nMoreFields);

        CreateCellsOfType = CREATETYPE_DUALGRIDANDSTITCHCELLS;
    }

    public AMRStitchCellAttributes(AMRStitchCellAttributes obj)
    {
        super(obj);

        CreateCellsOfType = obj.CreateCellsOfType;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return AMRStitchCellAttributes_numAdditionalAtts;
    }

    public boolean equals(AMRStitchCellAttributes obj)
    {
        // Create the return value
        return ((CreateCellsOfType == obj.CreateCellsOfType));
    }

    public String GetName() { return "AMRStitchCell"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetCreateCellsOfType(int CreateCellsOfType_)
    {
        CreateCellsOfType = CreateCellsOfType_;
        Select(0);
    }

    // Property getting methods
    public int GetCreateCellsOfType() { return CreateCellsOfType; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(CreateCellsOfType);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetCreateCellsOfType(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "CreateCellsOfType = ";
        if(CreateCellsOfType == CREATETYPE_DUALGRIDANDSTITCHCELLS)
            str = str + "CREATETYPE_DUALGRIDANDSTITCHCELLS";
        if(CreateCellsOfType == CREATETYPE_DUALGRID)
            str = str + "CREATETYPE_DUALGRID";
        if(CreateCellsOfType == CREATETYPE_STITCHCELLS)
            str = str + "CREATETYPE_STITCHCELLS";
        str = str + "\n";
        return str;
    }


    // Attributes
    private int CreateCellsOfType;
}

