// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef _GET_PLUGIN_ERRORS_RPC_H_
#define _GET_PLUGIN_ERRORS_RPC_H_
#include <mdsrpc_exports.h>

#include <VisItRPC.h>
#include <string>

// *******************************************************************
// Class: GetPluginErrorsRPC
//
// Purpose:
//   Return the list of errors generated by plugin initialization.
//
// Programmer: Jeremy Meredith
// Creation:   February  7, 2005
//
// Modifications:
//   Brad Whitlock, Fri Dec  7 11:45:37 PST 2007
//   Added TypeName override.
//
// *******************************************************************

class MDSERVER_RPC_API GetPluginErrorsRPC : public BlockingRPC
{
public:
    struct MDSERVER_RPC_API PluginErrors : public AttributeSubject
    {
        std::string errorString;
    public:
        PluginErrors();
        ~PluginErrors();
        virtual void SelectAll();
        virtual const std::string TypeName() const;
    };
public:
    GetPluginErrorsRPC();
    virtual ~GetPluginErrorsRPC();

    // Invokation method
    std::string operator()();

    // Property selection methods
    virtual void SelectAll();

    virtual const std::string TypeName() const;
private:
    PluginErrors errors;
};


#endif
