// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: avtSpeciesMetaData
//
// Purpose:
//    Contains species metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtSpeciesMetaData extends AttributeSubject
{
    private static int avtSpeciesMetaData_numAdditionalAtts = 7;

    public avtSpeciesMetaData()
    {
        super(avtSpeciesMetaData_numAdditionalAtts);

        name = new String("Species");
        originalName = new String("Species");
        validVariable = true;
        meshName = new String("mesh");
        materialName = new String("material");
        numMaterials = 0;
        species = new Vector();
    }

    public avtSpeciesMetaData(int nMoreFields)
    {
        super(avtSpeciesMetaData_numAdditionalAtts + nMoreFields);

        name = new String("Species");
        originalName = new String("Species");
        validVariable = true;
        meshName = new String("mesh");
        materialName = new String("material");
        numMaterials = 0;
        species = new Vector();
    }

    public avtSpeciesMetaData(avtSpeciesMetaData obj)
    {
        super(obj);

        int i;

        name = new String(obj.name);
        originalName = new String(obj.originalName);
        validVariable = obj.validVariable;
        meshName = new String(obj.meshName);
        materialName = new String(obj.materialName);
        numMaterials = obj.numMaterials;
        // *** Copy the species field ***
        species = new Vector(obj.species.size());
        for(i = 0; i < obj.species.size(); ++i)
        {
            avtMatSpeciesMetaData oldObj = (avtMatSpeciesMetaData)obj.species.elementAt(i);
            species.addElement(new avtMatSpeciesMetaData(oldObj));
        }


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtSpeciesMetaData_numAdditionalAtts;
    }

    public boolean equals(avtSpeciesMetaData obj)
    {
        int i;

        // Compare the elements in the species vector.
        boolean species_equal = (obj.species.size() == species.size());
        for(i = 0; (i < species.size()) && species_equal; ++i)
        {
            // Make references to avtMatSpeciesMetaData from Object.
            avtMatSpeciesMetaData species1 = (avtMatSpeciesMetaData)species.elementAt(i);
            avtMatSpeciesMetaData species2 = (avtMatSpeciesMetaData)obj.species.elementAt(i);
            species_equal = species1.equals(species2);
        }
        // Create the return value
        return ((name.equals(obj.name)) &&
                (originalName.equals(obj.originalName)) &&
                (validVariable == obj.validVariable) &&
                (meshName.equals(obj.meshName)) &&
                (materialName.equals(obj.materialName)) &&
                (numMaterials == obj.numMaterials) &&
                species_equal);
    }

    // Property setting methods
    public void SetName(String name_)
    {
        name = name_;
        Select(0);
    }

    public void SetOriginalName(String originalName_)
    {
        originalName = originalName_;
        Select(1);
    }

    public void SetValidVariable(boolean validVariable_)
    {
        validVariable = validVariable_;
        Select(2);
    }

    public void SetMeshName(String meshName_)
    {
        meshName = meshName_;
        Select(3);
    }

    public void SetMaterialName(String materialName_)
    {
        materialName = materialName_;
        Select(4);
    }

    public void SetNumMaterials(int numMaterials_)
    {
        numMaterials = numMaterials_;
        Select(5);
    }

    // Property getting methods
    public String  GetName() { return name; }
    public String  GetOriginalName() { return originalName; }
    public boolean GetValidVariable() { return validVariable; }
    public String  GetMeshName() { return meshName; }
    public String  GetMaterialName() { return materialName; }
    public int     GetNumMaterials() { return numMaterials; }
    public Vector  GetSpecies() { return species; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(name);
        if(WriteSelect(1, buf))
            buf.WriteString(originalName);
        if(WriteSelect(2, buf))
            buf.WriteBool(validVariable);
        if(WriteSelect(3, buf))
            buf.WriteString(meshName);
        if(WriteSelect(4, buf))
            buf.WriteString(materialName);
        if(WriteSelect(5, buf))
            buf.WriteInt(numMaterials);
        if(WriteSelect(6, buf))
        {
            buf.WriteInt(species.size());
            for(int i = 0; i < species.size(); ++i)
            {
                avtMatSpeciesMetaData tmp = (avtMatSpeciesMetaData)species.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetName(buf.ReadString());
            break;
        case 1:
            SetOriginalName(buf.ReadString());
            break;
        case 2:
            SetValidVariable(buf.ReadBool());
            break;
        case 3:
            SetMeshName(buf.ReadString());
            break;
        case 4:
            SetMaterialName(buf.ReadString());
            break;
        case 5:
            SetNumMaterials(buf.ReadInt());
            break;
        case 6:
            {
                int len = buf.ReadInt();
                species.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtMatSpeciesMetaData tmp = new avtMatSpeciesMetaData();
                    tmp.Read(buf);
                    species.addElement(tmp);
                }
            }
            Select(6);
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("name", name, indent) + "\n";
        str = str + stringToString("originalName", originalName, indent) + "\n";
        str = str + boolToString("validVariable", validVariable, indent) + "\n";
        str = str + stringToString("meshName", meshName, indent) + "\n";
        str = str + stringToString("materialName", materialName, indent) + "\n";
        str = str + intToString("numMaterials", numMaterials, indent) + "\n";
        str = str + indent + "species = {\n";
        for(int i = 0; i < species.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)species.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < species.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddSpecies(avtMatSpeciesMetaData obj)
    {
        species.addElement(new avtMatSpeciesMetaData(obj));
        Select(6);
    }

    public void ClearSpecies()
    {
        species.clear();
        Select(6);
    }

    public void RemoveSpecies(int index)
    {
        if(index >= 0 && index < species.size())
        {
            species.remove(index);
            Select(6);
        }
    }

    public int GetNumSpecies()
    {
        return species.size();
    }

    public avtMatSpeciesMetaData GetSpecies(int i)
    {
        avtMatSpeciesMetaData tmp = (avtMatSpeciesMetaData)species.elementAt(i);
        return tmp;
    }


    // Attributes
    private String  name;
    private String  originalName;
    private boolean validVariable;
    private String  meshName;
    private String  materialName;
    private int     numMaterials;
    private Vector  species; // vector of avtMatSpeciesMetaData objects
}

