// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: avtSimulationInformation
//
// Purpose:
//    Contains information about simulation connections
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtSimulationInformation extends AttributeSubject
{
    private static int avtSimulationInformation_numAdditionalAtts = 9;

    // Enum values
    public final static int RUNMODE_UNKNOWN = 0;
    public final static int RUNMODE_RUNNING = 1;
    public final static int RUNMODE_STOPPED = 2;


    public avtSimulationInformation()
    {
        super(avtSimulationInformation_numAdditionalAtts);

        host = new String("");
        port = 0;
        securityKey = new String("");
        otherNames = new Vector();
        otherValues = new Vector();
        genericCommands = new Vector();
        mode = RUNMODE_UNKNOWN;
        customCommands = new Vector();
        message = new String("");
    }

    public avtSimulationInformation(int nMoreFields)
    {
        super(avtSimulationInformation_numAdditionalAtts + nMoreFields);

        host = new String("");
        port = 0;
        securityKey = new String("");
        otherNames = new Vector();
        otherValues = new Vector();
        genericCommands = new Vector();
        mode = RUNMODE_UNKNOWN;
        customCommands = new Vector();
        message = new String("");
    }

    public avtSimulationInformation(avtSimulationInformation obj)
    {
        super(obj);

        int i;

        host = new String(obj.host);
        port = obj.port;
        securityKey = new String(obj.securityKey);
        otherNames = new Vector(obj.otherNames.size());
        for(i = 0; i < obj.otherNames.size(); ++i)
            otherNames.addElement(new String((String)obj.otherNames.elementAt(i)));

        otherValues = new Vector(obj.otherValues.size());
        for(i = 0; i < obj.otherValues.size(); ++i)
            otherValues.addElement(new String((String)obj.otherValues.elementAt(i)));

        // *** Copy the genericCommands field ***
        genericCommands = new Vector(obj.genericCommands.size());
        for(i = 0; i < obj.genericCommands.size(); ++i)
        {
            avtSimulationCommandSpecification oldObj = (avtSimulationCommandSpecification)obj.genericCommands.elementAt(i);
            genericCommands.addElement(new avtSimulationCommandSpecification(oldObj));
        }

        mode = obj.mode;
        // *** Copy the customCommands field ***
        customCommands = new Vector(obj.customCommands.size());
        for(i = 0; i < obj.customCommands.size(); ++i)
        {
            avtSimulationCommandSpecification oldObj = (avtSimulationCommandSpecification)obj.customCommands.elementAt(i);
            customCommands.addElement(new avtSimulationCommandSpecification(oldObj));
        }

        message = new String(obj.message);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtSimulationInformation_numAdditionalAtts;
    }

    public boolean equals(avtSimulationInformation obj)
    {
        int i;

        // Compare the elements in the otherNames vector.
        boolean otherNames_equal = (obj.otherNames.size() == otherNames.size());
        for(i = 0; (i < otherNames.size()) && otherNames_equal; ++i)
        {
            // Make references to String from Object.
            String otherNames1 = (String)otherNames.elementAt(i);
            String otherNames2 = (String)obj.otherNames.elementAt(i);
            otherNames_equal = otherNames1.equals(otherNames2);
        }
        // Compare the elements in the otherValues vector.
        boolean otherValues_equal = (obj.otherValues.size() == otherValues.size());
        for(i = 0; (i < otherValues.size()) && otherValues_equal; ++i)
        {
            // Make references to String from Object.
            String otherValues1 = (String)otherValues.elementAt(i);
            String otherValues2 = (String)obj.otherValues.elementAt(i);
            otherValues_equal = otherValues1.equals(otherValues2);
        }
        // Compare the elements in the genericCommands vector.
        boolean genericCommands_equal = (obj.genericCommands.size() == genericCommands.size());
        for(i = 0; (i < genericCommands.size()) && genericCommands_equal; ++i)
        {
            // Make references to avtSimulationCommandSpecification from Object.
            avtSimulationCommandSpecification genericCommands1 = (avtSimulationCommandSpecification)genericCommands.elementAt(i);
            avtSimulationCommandSpecification genericCommands2 = (avtSimulationCommandSpecification)obj.genericCommands.elementAt(i);
            genericCommands_equal = genericCommands1.equals(genericCommands2);
        }
        // Compare the elements in the customCommands vector.
        boolean customCommands_equal = (obj.customCommands.size() == customCommands.size());
        for(i = 0; (i < customCommands.size()) && customCommands_equal; ++i)
        {
            // Make references to avtSimulationCommandSpecification from Object.
            avtSimulationCommandSpecification customCommands1 = (avtSimulationCommandSpecification)customCommands.elementAt(i);
            avtSimulationCommandSpecification customCommands2 = (avtSimulationCommandSpecification)obj.customCommands.elementAt(i);
            customCommands_equal = customCommands1.equals(customCommands2);
        }
        // Create the return value
        return ((host.equals(obj.host)) &&
                (port == obj.port) &&
                (securityKey.equals(obj.securityKey)) &&
                otherNames_equal &&
                otherValues_equal &&
                genericCommands_equal &&
                (mode == obj.mode) &&
                customCommands_equal &&
                (message.equals(obj.message)));
    }

    // Property setting methods
    public void SetHost(String host_)
    {
        host = host_;
        Select(0);
    }

    public void SetPort(int port_)
    {
        port = port_;
        Select(1);
    }

    public void SetSecurityKey(String securityKey_)
    {
        securityKey = securityKey_;
        Select(2);
    }

    public void SetOtherNames(Vector otherNames_)
    {
        otherNames = otherNames_;
        Select(3);
    }

    public void SetOtherValues(Vector otherValues_)
    {
        otherValues = otherValues_;
        Select(4);
    }

    public void SetMode(int mode_)
    {
        mode = mode_;
        Select(6);
    }

    public void SetMessage(String message_)
    {
        message = message_;
        Select(8);
    }

    // Property getting methods
    public String GetHost() { return host; }
    public int    GetPort() { return port; }
    public String GetSecurityKey() { return securityKey; }
    public Vector GetOtherNames() { return otherNames; }
    public Vector GetOtherValues() { return otherValues; }
    public Vector GetGenericCommands() { return genericCommands; }
    public int    GetMode() { return mode; }
    public Vector GetCustomCommands() { return customCommands; }
    public String GetMessage() { return message; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(host);
        if(WriteSelect(1, buf))
            buf.WriteInt(port);
        if(WriteSelect(2, buf))
            buf.WriteString(securityKey);
        if(WriteSelect(3, buf))
            buf.WriteStringVector(otherNames);
        if(WriteSelect(4, buf))
            buf.WriteStringVector(otherValues);
        if(WriteSelect(5, buf))
        {
            buf.WriteInt(genericCommands.size());
            for(int i = 0; i < genericCommands.size(); ++i)
            {
                avtSimulationCommandSpecification tmp = (avtSimulationCommandSpecification)genericCommands.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(6, buf))
            buf.WriteInt(mode);
        if(WriteSelect(7, buf))
        {
            buf.WriteInt(customCommands.size());
            for(int i = 0; i < customCommands.size(); ++i)
            {
                avtSimulationCommandSpecification tmp = (avtSimulationCommandSpecification)customCommands.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(8, buf))
            buf.WriteString(message);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetHost(buf.ReadString());
            break;
        case 1:
            SetPort(buf.ReadInt());
            break;
        case 2:
            SetSecurityKey(buf.ReadString());
            break;
        case 3:
            SetOtherNames(buf.ReadStringVector());
            break;
        case 4:
            SetOtherValues(buf.ReadStringVector());
            break;
        case 5:
            {
                int len = buf.ReadInt();
                genericCommands.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtSimulationCommandSpecification tmp = new avtSimulationCommandSpecification();
                    tmp.Read(buf);
                    genericCommands.addElement(tmp);
                }
            }
            Select(5);
            break;
        case 6:
            SetMode(buf.ReadInt());
            break;
        case 7:
            {
                int len = buf.ReadInt();
                customCommands.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtSimulationCommandSpecification tmp = new avtSimulationCommandSpecification();
                    tmp.Read(buf);
                    customCommands.addElement(tmp);
                }
            }
            Select(7);
            break;
        case 8:
            SetMessage(buf.ReadString());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("host", host, indent) + "\n";
        str = str + intToString("port", port, indent) + "\n";
        str = str + stringToString("securityKey", securityKey, indent) + "\n";
        str = str + stringVectorToString("otherNames", otherNames, indent) + "\n";
        str = str + stringVectorToString("otherValues", otherValues, indent) + "\n";
        str = str + indent + "genericCommands = {\n";
        for(int i = 0; i < genericCommands.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)genericCommands.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < genericCommands.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "mode = ";
        if(mode == RUNMODE_UNKNOWN)
            str = str + "RUNMODE_UNKNOWN";
        if(mode == RUNMODE_RUNNING)
            str = str + "RUNMODE_RUNNING";
        if(mode == RUNMODE_STOPPED)
            str = str + "RUNMODE_STOPPED";
        str = str + "\n";
        str = str + indent + "customCommands = {\n";
        for(int i = 0; i < customCommands.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)customCommands.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < customCommands.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + stringToString("message", message, indent) + "\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddGenericCommands(avtSimulationCommandSpecification obj)
    {
        genericCommands.addElement(new avtSimulationCommandSpecification(obj));
        Select(5);
    }

    public void ClearGenericCommands()
    {
        genericCommands.clear();
        Select(5);
    }

    public void RemoveGenericCommands(int index)
    {
        if(index >= 0 && index < genericCommands.size())
        {
            genericCommands.remove(index);
            Select(5);
        }
    }

    public int GetNumGenericCommands()
    {
        return genericCommands.size();
    }

    public avtSimulationCommandSpecification GetGenericCommands(int i)
    {
        avtSimulationCommandSpecification tmp = (avtSimulationCommandSpecification)genericCommands.elementAt(i);
        return tmp;
    }

    public void AddCustomCommands(avtSimulationCommandSpecification obj)
    {
        customCommands.addElement(new avtSimulationCommandSpecification(obj));
        Select(7);
    }

    public void ClearCustomCommands()
    {
        customCommands.clear();
        Select(7);
    }

    public void RemoveCustomCommands(int index)
    {
        if(index >= 0 && index < customCommands.size())
        {
            customCommands.remove(index);
            Select(7);
        }
    }

    public int GetNumCustomCommands()
    {
        return customCommands.size();
    }

    public avtSimulationCommandSpecification GetCustomCommands(int i)
    {
        avtSimulationCommandSpecification tmp = (avtSimulationCommandSpecification)customCommands.elementAt(i);
        return tmp;
    }


    // Attributes
    private String host;
    private int    port;
    private String securityKey;
    private Vector otherNames; // vector of String objects
    private Vector otherValues; // vector of String objects
    private Vector genericCommands; // vector of avtSimulationCommandSpecification objects
    private int    mode;
    private Vector customCommands; // vector of avtSimulationCommandSpecification objects
    private String message;
}

