// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;
import java.lang.Double;
import java.lang.Integer;

// ****************************************************************************
// Class: avtScalarMetaData
//
// Purpose:
//    Contains scalar metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtScalarMetaData extends avtVarMetaData
{
    private static int avtScalarMetaData_numAdditionalAtts = 14;

    // Enum values
    public final static int PARTIALCELLMODES_INCLUDE = 0;
    public final static int PARTIALCELLMODES_EXCLUDE = 1;
    public final static int PARTIALCELLMODES_DISSECT = 2;

    public final static int ENUMTYPES_NONE = 0;
    public final static int ENUMTYPES_BYVALUE = 1;
    public final static int ENUMTYPES_BYRANGE = 2;
    public final static int ENUMTYPES_BYBITMASK = 3;
    public final static int ENUMTYPES_BYNCHOOSER = 4;

    public final static int MISSINGDATA_MISSINGDATA_NONE = 0;
    public final static int MISSINGDATA_MISSINGDATA_VALUE = 1;
    public final static int MISSINGDATA_MISSINGDATA_VALID_MIN = 2;
    public final static int MISSINGDATA_MISSINGDATA_VALID_MAX = 3;
    public final static int MISSINGDATA_MISSINGDATA_VALID_RANGE = 4;


    public avtScalarMetaData()
    {
        super(avtScalarMetaData_numAdditionalAtts);

        treatAsASCII = false;
        enumerationType = ENUMTYPES_NONE;
        enumNames = new Vector();
        enumRanges = new Vector();
        enumAlwaysExclude = new double[2];
        enumAlwaysExclude[0] = 0;
        enumAlwaysExclude[1] = 0;
        enumAlwaysInclude = new double[2];
        enumAlwaysInclude[0] = 0;
        enumAlwaysInclude[1] = 0;
        enumPartialCellMode = PARTIALCELLMODES_EXCLUDE;
        enumGraphEdges = new Vector();
        enumGraphEdgeNames = new Vector();
        enumGraphEdgeNameIndexs = new Vector();
        enumNChooseRN = 0;
        enumNChooseRMaxR = 0;
        missingDataType = MISSINGDATA_MISSINGDATA_NONE;
        missingData = new double[2];
        missingData[0] = 0;
        missingData[1] = 0;
    }

    public avtScalarMetaData(int nMoreFields)
    {
        super(avtScalarMetaData_numAdditionalAtts + nMoreFields);

        treatAsASCII = false;
        enumerationType = ENUMTYPES_NONE;
        enumNames = new Vector();
        enumRanges = new Vector();
        enumAlwaysExclude = new double[2];
        enumAlwaysExclude[0] = 0;
        enumAlwaysExclude[1] = 0;
        enumAlwaysInclude = new double[2];
        enumAlwaysInclude[0] = 0;
        enumAlwaysInclude[1] = 0;
        enumPartialCellMode = PARTIALCELLMODES_EXCLUDE;
        enumGraphEdges = new Vector();
        enumGraphEdgeNames = new Vector();
        enumGraphEdgeNameIndexs = new Vector();
        enumNChooseRN = 0;
        enumNChooseRMaxR = 0;
        missingDataType = MISSINGDATA_MISSINGDATA_NONE;
        missingData = new double[2];
        missingData[0] = 0;
        missingData[1] = 0;
    }

    public avtScalarMetaData(avtScalarMetaData obj)
    {
        super(obj);

        int i;

        treatAsASCII = obj.treatAsASCII;
        enumerationType = obj.enumerationType;
        enumNames = new Vector(obj.enumNames.size());
        for(i = 0; i < obj.enumNames.size(); ++i)
            enumNames.addElement(new String((String)obj.enumNames.elementAt(i)));

        enumRanges = new Vector(obj.enumRanges.size());
        for(i = 0; i < obj.enumRanges.size(); ++i)
        {
            Double dv = (Double)obj.enumRanges.elementAt(i);
            enumRanges.addElement(new Double(dv.doubleValue()));
        }

        enumAlwaysExclude = new double[2];
        enumAlwaysExclude[0] = obj.enumAlwaysExclude[0];
        enumAlwaysExclude[1] = obj.enumAlwaysExclude[1];

        enumAlwaysInclude = new double[2];
        enumAlwaysInclude[0] = obj.enumAlwaysInclude[0];
        enumAlwaysInclude[1] = obj.enumAlwaysInclude[1];

        enumPartialCellMode = obj.enumPartialCellMode;
        enumGraphEdges = new Vector();
        for(i = 0; i < obj.enumGraphEdges.size(); ++i)
        {
            Integer iv = (Integer)obj.enumGraphEdges.elementAt(i);
            enumGraphEdges.addElement(new Integer(iv.intValue()));
        }
        enumGraphEdgeNames = new Vector(obj.enumGraphEdgeNames.size());
        for(i = 0; i < obj.enumGraphEdgeNames.size(); ++i)
            enumGraphEdgeNames.addElement(new String((String)obj.enumGraphEdgeNames.elementAt(i)));

        enumGraphEdgeNameIndexs = new Vector();
        for(i = 0; i < obj.enumGraphEdgeNameIndexs.size(); ++i)
        {
            Integer iv = (Integer)obj.enumGraphEdgeNameIndexs.elementAt(i);
            enumGraphEdgeNameIndexs.addElement(new Integer(iv.intValue()));
        }
        enumNChooseRN = obj.enumNChooseRN;
        enumNChooseRMaxR = obj.enumNChooseRMaxR;
        missingDataType = obj.missingDataType;
        missingData = new double[2];
        missingData[0] = obj.missingData[0];
        missingData[1] = obj.missingData[1];


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtScalarMetaData_numAdditionalAtts;
    }

    public boolean equals(avtScalarMetaData obj)
    {
        int i;

        // Compare the elements in the enumNames vector.
        boolean enumNames_equal = (obj.enumNames.size() == enumNames.size());
        for(i = 0; (i < enumNames.size()) && enumNames_equal; ++i)
        {
            // Make references to String from Object.
            String enumNames1 = (String)enumNames.elementAt(i);
            String enumNames2 = (String)obj.enumNames.elementAt(i);
            enumNames_equal = enumNames1.equals(enumNames2);
        }
        // Compare the elements in the enumRanges vector.
        boolean enumRanges_equal = (obj.enumRanges.size() == enumRanges.size());
        for(i = 0; (i < enumRanges.size()) && enumRanges_equal; ++i)
        {
            // Make references to Double from Object.
            Double enumRanges1 = (Double)enumRanges.elementAt(i);
            Double enumRanges2 = (Double)obj.enumRanges.elementAt(i);
            enumRanges_equal = enumRanges1.equals(enumRanges2);
        }
        // Compare the enumAlwaysExclude arrays.
        boolean enumAlwaysExclude_equal = true;
        for(i = 0; i < 2 && enumAlwaysExclude_equal; ++i)
            enumAlwaysExclude_equal = (enumAlwaysExclude[i] == obj.enumAlwaysExclude[i]);

        // Compare the enumAlwaysInclude arrays.
        boolean enumAlwaysInclude_equal = true;
        for(i = 0; i < 2 && enumAlwaysInclude_equal; ++i)
            enumAlwaysInclude_equal = (enumAlwaysInclude[i] == obj.enumAlwaysInclude[i]);

        // Compare the elements in the enumGraphEdges vector.
        boolean enumGraphEdges_equal = (obj.enumGraphEdges.size() == enumGraphEdges.size());
        for(i = 0; (i < enumGraphEdges.size()) && enumGraphEdges_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer enumGraphEdges1 = (Integer)enumGraphEdges.elementAt(i);
            Integer enumGraphEdges2 = (Integer)obj.enumGraphEdges.elementAt(i);
            enumGraphEdges_equal = enumGraphEdges1.equals(enumGraphEdges2);
        }
        // Compare the elements in the enumGraphEdgeNames vector.
        boolean enumGraphEdgeNames_equal = (obj.enumGraphEdgeNames.size() == enumGraphEdgeNames.size());
        for(i = 0; (i < enumGraphEdgeNames.size()) && enumGraphEdgeNames_equal; ++i)
        {
            // Make references to String from Object.
            String enumGraphEdgeNames1 = (String)enumGraphEdgeNames.elementAt(i);
            String enumGraphEdgeNames2 = (String)obj.enumGraphEdgeNames.elementAt(i);
            enumGraphEdgeNames_equal = enumGraphEdgeNames1.equals(enumGraphEdgeNames2);
        }
        // Compare the elements in the enumGraphEdgeNameIndexs vector.
        boolean enumGraphEdgeNameIndexs_equal = (obj.enumGraphEdgeNameIndexs.size() == enumGraphEdgeNameIndexs.size());
        for(i = 0; (i < enumGraphEdgeNameIndexs.size()) && enumGraphEdgeNameIndexs_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer enumGraphEdgeNameIndexs1 = (Integer)enumGraphEdgeNameIndexs.elementAt(i);
            Integer enumGraphEdgeNameIndexs2 = (Integer)obj.enumGraphEdgeNameIndexs.elementAt(i);
            enumGraphEdgeNameIndexs_equal = enumGraphEdgeNameIndexs1.equals(enumGraphEdgeNameIndexs2);
        }
        // Compare the missingData arrays.
        boolean missingData_equal = true;
        for(i = 0; i < 2 && missingData_equal; ++i)
            missingData_equal = (missingData[i] == obj.missingData[i]);

        // Create the return value
        return (super.equals(obj) && (treatAsASCII == obj.treatAsASCII) &&
                (enumerationType == obj.enumerationType) &&
                enumNames_equal &&
                enumRanges_equal &&
                enumAlwaysExclude_equal &&
                enumAlwaysInclude_equal &&
                (enumPartialCellMode == obj.enumPartialCellMode) &&
                enumGraphEdges_equal &&
                enumGraphEdgeNames_equal &&
                enumGraphEdgeNameIndexs_equal &&
                (enumNChooseRN == obj.enumNChooseRN) &&
                (enumNChooseRMaxR == obj.enumNChooseRMaxR) &&
                (missingDataType == obj.missingDataType) &&
                missingData_equal);
    }

    // Property setting methods
    public void SetTreatAsASCII(boolean treatAsASCII_)
    {
        treatAsASCII = treatAsASCII_;
        Select((new avtScalarMetaData()).Offset() + 0);
    }

    public void SetEnumerationType(int enumerationType_)
    {
        enumerationType = enumerationType_;
        Select((new avtScalarMetaData()).Offset() + 1);
    }

    public void SetEnumNames(Vector enumNames_)
    {
        enumNames = enumNames_;
        Select((new avtScalarMetaData()).Offset() + 2);
    }

    public void SetEnumRanges(Vector enumRanges_)
    {
        enumRanges = enumRanges_;
        Select((new avtScalarMetaData()).Offset() + 3);
    }

    public void SetEnumAlwaysExclude(double[] enumAlwaysExclude_)
    {
        enumAlwaysExclude[0] = enumAlwaysExclude_[0];
        enumAlwaysExclude[1] = enumAlwaysExclude_[1];
        Select((new avtScalarMetaData()).Offset() + 4);
    }

    public void SetEnumAlwaysExclude(double e0, double e1)
    {
        enumAlwaysExclude[0] = e0;
        enumAlwaysExclude[1] = e1;
        Select((new avtScalarMetaData()).Offset() + 4);
    }

    public void SetEnumAlwaysInclude(double[] enumAlwaysInclude_)
    {
        enumAlwaysInclude[0] = enumAlwaysInclude_[0];
        enumAlwaysInclude[1] = enumAlwaysInclude_[1];
        Select((new avtScalarMetaData()).Offset() + 5);
    }

    public void SetEnumAlwaysInclude(double e0, double e1)
    {
        enumAlwaysInclude[0] = e0;
        enumAlwaysInclude[1] = e1;
        Select((new avtScalarMetaData()).Offset() + 5);
    }

    public void SetEnumPartialCellMode(int enumPartialCellMode_)
    {
        enumPartialCellMode = enumPartialCellMode_;
        Select((new avtScalarMetaData()).Offset() + 6);
    }

    public void SetEnumGraphEdges(Vector enumGraphEdges_)
    {
        enumGraphEdges = enumGraphEdges_;
        Select((new avtScalarMetaData()).Offset() + 7);
    }

    public void SetEnumGraphEdgeNames(Vector enumGraphEdgeNames_)
    {
        enumGraphEdgeNames = enumGraphEdgeNames_;
        Select((new avtScalarMetaData()).Offset() + 8);
    }

    public void SetEnumGraphEdgeNameIndexs(Vector enumGraphEdgeNameIndexs_)
    {
        enumGraphEdgeNameIndexs = enumGraphEdgeNameIndexs_;
        Select((new avtScalarMetaData()).Offset() + 9);
    }

    public void SetEnumNChooseRN(int enumNChooseRN_)
    {
        enumNChooseRN = enumNChooseRN_;
        Select((new avtScalarMetaData()).Offset() + 10);
    }

    public void SetEnumNChooseRMaxR(int enumNChooseRMaxR_)
    {
        enumNChooseRMaxR = enumNChooseRMaxR_;
        Select((new avtScalarMetaData()).Offset() + 11);
    }

    public void SetMissingDataType(int missingDataType_)
    {
        missingDataType = missingDataType_;
        Select((new avtScalarMetaData()).Offset() + 12);
    }

    public void SetMissingData(double[] missingData_)
    {
        missingData[0] = missingData_[0];
        missingData[1] = missingData_[1];
        Select((new avtScalarMetaData()).Offset() + 13);
    }

    public void SetMissingData(double e0, double e1)
    {
        missingData[0] = e0;
        missingData[1] = e1;
        Select((new avtScalarMetaData()).Offset() + 13);
    }

    // Property getting methods
    public boolean  GetTreatAsASCII() { return treatAsASCII; }
    public int      GetEnumerationType() { return enumerationType; }
    public Vector   GetEnumNames() { return enumNames; }
    public Vector   GetEnumRanges() { return enumRanges; }
    public double[] GetEnumAlwaysExclude() { return enumAlwaysExclude; }
    public double[] GetEnumAlwaysInclude() { return enumAlwaysInclude; }
    public int      GetEnumPartialCellMode() { return enumPartialCellMode; }
    public Vector   GetEnumGraphEdges() { return enumGraphEdges; }
    public Vector   GetEnumGraphEdgeNames() { return enumGraphEdgeNames; }
    public Vector   GetEnumGraphEdgeNameIndexs() { return enumGraphEdgeNameIndexs; }
    public int      GetEnumNChooseRN() { return enumNChooseRN; }
    public int      GetEnumNChooseRMaxR() { return enumNChooseRMaxR; }
    public int      GetMissingDataType() { return missingDataType; }
    public double[] GetMissingData() { return missingData; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        super.WriteAtts(buf);

        int offset = (new avtScalarMetaData()).Offset();
        if(WriteSelect(offset + 0, buf))
            buf.WriteBool(treatAsASCII);
        if(WriteSelect(offset + 1, buf))
            buf.WriteInt(enumerationType);
        if(WriteSelect(offset + 2, buf))
            buf.WriteStringVector(enumNames);
        if(WriteSelect(offset + 3, buf))
            buf.WriteDoubleVector(enumRanges);
        if(WriteSelect(offset + 4, buf))
            buf.WriteDoubleArray(enumAlwaysExclude);
        if(WriteSelect(offset + 5, buf))
            buf.WriteDoubleArray(enumAlwaysInclude);
        if(WriteSelect(offset + 6, buf))
            buf.WriteInt(enumPartialCellMode);
        if(WriteSelect(offset + 7, buf))
            buf.WriteIntVector(enumGraphEdges);
        if(WriteSelect(offset + 8, buf))
            buf.WriteStringVector(enumGraphEdgeNames);
        if(WriteSelect(offset + 9, buf))
            buf.WriteIntVector(enumGraphEdgeNameIndexs);
        if(WriteSelect(offset + 10, buf))
            buf.WriteInt(enumNChooseRN);
        if(WriteSelect(offset + 11, buf))
            buf.WriteInt(enumNChooseRMaxR);
        if(WriteSelect(offset + 12, buf))
            buf.WriteInt(missingDataType);
        if(WriteSelect(offset + 13, buf))
            buf.WriteDoubleArray(missingData);
    }

    public void ReadAtts(int id, CommunicationBuffer buf)
    {
        int offset = (new avtScalarMetaData()).Offset();
        int index = id - offset;
        switch(index)
        {
        case 0:
            SetTreatAsASCII(buf.ReadBool());
            break;
        case 1:
            SetEnumerationType(buf.ReadInt());
            break;
        case 2:
            SetEnumNames(buf.ReadStringVector());
            break;
        case 3:
            SetEnumRanges(buf.ReadDoubleVector());
            break;
        case 4:
            SetEnumAlwaysExclude(buf.ReadDoubleArray());
            break;
        case 5:
            SetEnumAlwaysInclude(buf.ReadDoubleArray());
            break;
        case 6:
            SetEnumPartialCellMode(buf.ReadInt());
            break;
        case 7:
            SetEnumGraphEdges(buf.ReadIntVector());
            break;
        case 8:
            SetEnumGraphEdgeNames(buf.ReadStringVector());
            break;
        case 9:
            SetEnumGraphEdgeNameIndexs(buf.ReadIntVector());
            break;
        case 10:
            SetEnumNChooseRN(buf.ReadInt());
            break;
        case 11:
            SetEnumNChooseRMaxR(buf.ReadInt());
            break;
        case 12:
            SetMissingDataType(buf.ReadInt());
            break;
        case 13:
            SetMissingData(buf.ReadDoubleArray());
            break;
        default:
            super.ReadAtts(id, buf);
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("treatAsASCII", treatAsASCII, indent) + "\n";
        str = str + indent + "enumerationType = ";
        if(enumerationType == ENUMTYPES_NONE)
            str = str + "ENUMTYPES_NONE";
        if(enumerationType == ENUMTYPES_BYVALUE)
            str = str + "ENUMTYPES_BYVALUE";
        if(enumerationType == ENUMTYPES_BYRANGE)
            str = str + "ENUMTYPES_BYRANGE";
        if(enumerationType == ENUMTYPES_BYBITMASK)
            str = str + "ENUMTYPES_BYBITMASK";
        if(enumerationType == ENUMTYPES_BYNCHOOSER)
            str = str + "ENUMTYPES_BYNCHOOSER";
        str = str + "\n";
        str = str + stringVectorToString("enumNames", enumNames, indent) + "\n";
        str = str + doubleVectorToString("enumRanges", enumRanges, indent) + "\n";
        str = str + doubleArrayToString("enumAlwaysExclude", enumAlwaysExclude, indent) + "\n";
        str = str + doubleArrayToString("enumAlwaysInclude", enumAlwaysInclude, indent) + "\n";
        str = str + indent + "enumPartialCellMode = ";
        if(enumPartialCellMode == PARTIALCELLMODES_INCLUDE)
            str = str + "PARTIALCELLMODES_INCLUDE";
        if(enumPartialCellMode == PARTIALCELLMODES_EXCLUDE)
            str = str + "PARTIALCELLMODES_EXCLUDE";
        if(enumPartialCellMode == PARTIALCELLMODES_DISSECT)
            str = str + "PARTIALCELLMODES_DISSECT";
        str = str + "\n";
        str = str + intVectorToString("enumGraphEdges", enumGraphEdges, indent) + "\n";
        str = str + stringVectorToString("enumGraphEdgeNames", enumGraphEdgeNames, indent) + "\n";
        str = str + intVectorToString("enumGraphEdgeNameIndexs", enumGraphEdgeNameIndexs, indent) + "\n";
        str = str + intToString("enumNChooseRN", enumNChooseRN, indent) + "\n";
        str = str + intToString("enumNChooseRMaxR", enumNChooseRMaxR, indent) + "\n";
        str = str + indent + "missingDataType = ";
        if(missingDataType == MISSINGDATA_MISSINGDATA_NONE)
            str = str + "MISSINGDATA_MISSINGDATA_NONE";
        if(missingDataType == MISSINGDATA_MISSINGDATA_VALUE)
            str = str + "MISSINGDATA_MISSINGDATA_VALUE";
        if(missingDataType == MISSINGDATA_MISSINGDATA_VALID_MIN)
            str = str + "MISSINGDATA_MISSINGDATA_VALID_MIN";
        if(missingDataType == MISSINGDATA_MISSINGDATA_VALID_MAX)
            str = str + "MISSINGDATA_MISSINGDATA_VALID_MAX";
        if(missingDataType == MISSINGDATA_MISSINGDATA_VALID_RANGE)
            str = str + "MISSINGDATA_MISSINGDATA_VALID_RANGE";
        str = str + "\n";
        str = str + doubleArrayToString("missingData", missingData, indent) + "\n";
        return super.toString(indent) + str;
    }


    // Attributes
    private boolean  treatAsASCII;
    private int      enumerationType;
    private Vector   enumNames; // vector of String objects
    private Vector   enumRanges; // vector of Double objects
    private double[] enumAlwaysExclude;
    private double[] enumAlwaysInclude;
    private int      enumPartialCellMode;
    private Vector   enumGraphEdges; // vector of Integer objects
    private Vector   enumGraphEdgeNames; // vector of String objects
    private Vector   enumGraphEdgeNameIndexs; // vector of Integer objects
    private int      enumNChooseRN;
    private int      enumNChooseRMaxR;
    private int      missingDataType;
    private double[] missingData;
}

