// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: avtArrayMetaData
//
// Purpose:
//    Contains array metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtArrayMetaData extends avtVarMetaData
{
    private static int avtArrayMetaData_numAdditionalAtts = 2;

    public avtArrayMetaData()
    {
        super(avtArrayMetaData_numAdditionalAtts);

        nVars = 0;
        compNames = new Vector();
    }

    public avtArrayMetaData(int nMoreFields)
    {
        super(avtArrayMetaData_numAdditionalAtts + nMoreFields);

        nVars = 0;
        compNames = new Vector();
    }

    public avtArrayMetaData(avtArrayMetaData obj)
    {
        super(obj);

        int i;

        nVars = obj.nVars;
        compNames = new Vector(obj.compNames.size());
        for(i = 0; i < obj.compNames.size(); ++i)
            compNames.addElement(new String((String)obj.compNames.elementAt(i)));


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtArrayMetaData_numAdditionalAtts;
    }

    public boolean equals(avtArrayMetaData obj)
    {
        int i;

        // Compare the elements in the compNames vector.
        boolean compNames_equal = (obj.compNames.size() == compNames.size());
        for(i = 0; (i < compNames.size()) && compNames_equal; ++i)
        {
            // Make references to String from Object.
            String compNames1 = (String)compNames.elementAt(i);
            String compNames2 = (String)obj.compNames.elementAt(i);
            compNames_equal = compNames1.equals(compNames2);
        }
        // Create the return value
        return (super.equals(obj) && (nVars == obj.nVars) &&
                compNames_equal);
    }

    // Property setting methods
    public void SetNVars(int nVars_)
    {
        nVars = nVars_;
        Select((new avtArrayMetaData()).Offset() + 0);
    }

    public void SetCompNames(Vector compNames_)
    {
        compNames = compNames_;
        Select((new avtArrayMetaData()).Offset() + 1);
    }

    // Property getting methods
    public int    GetNVars() { return nVars; }
    public Vector GetCompNames() { return compNames; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        super.WriteAtts(buf);

        int offset = (new avtArrayMetaData()).Offset();
        if(WriteSelect(offset + 0, buf))
            buf.WriteInt(nVars);
        if(WriteSelect(offset + 1, buf))
            buf.WriteStringVector(compNames);
    }

    public void ReadAtts(int id, CommunicationBuffer buf)
    {
        int offset = (new avtArrayMetaData()).Offset();
        int index = id - offset;
        switch(index)
        {
        case 0:
            SetNVars(buf.ReadInt());
            break;
        case 1:
            SetCompNames(buf.ReadStringVector());
            break;
        default:
            super.ReadAtts(id, buf);
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("nVars", nVars, indent) + "\n";
        str = str + stringVectorToString("compNames", compNames, indent) + "\n";
        return super.toString(indent) + str;
    }


    // Attributes
    private int    nVars;
    private Vector compNames; // vector of String objects
}

