// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: VisualCueList
//
// Purpose:
//    container object for shipping vectors of visual cues
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class VisualCueList extends AttributeSubject
{
    private static int VisualCueList_numAdditionalAtts = 1;

    public VisualCueList()
    {
        super(VisualCueList_numAdditionalAtts);

        cues = new Vector();
    }

    public VisualCueList(int nMoreFields)
    {
        super(VisualCueList_numAdditionalAtts + nMoreFields);

        cues = new Vector();
    }

    public VisualCueList(VisualCueList obj)
    {
        super(obj);

        int i;

        // *** Copy the cues field ***
        cues = new Vector(obj.cues.size());
        for(i = 0; i < obj.cues.size(); ++i)
        {
            VisualCueInfo oldObj = (VisualCueInfo)obj.cues.elementAt(i);
            cues.addElement(new VisualCueInfo(oldObj));
        }


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return VisualCueList_numAdditionalAtts;
    }

    public boolean equals(VisualCueList obj)
    {
        int i;

        // Compare the elements in the cues vector.
        boolean cues_equal = (obj.cues.size() == cues.size());
        for(i = 0; (i < cues.size()) && cues_equal; ++i)
        {
            // Make references to VisualCueInfo from Object.
            VisualCueInfo cues1 = (VisualCueInfo)cues.elementAt(i);
            VisualCueInfo cues2 = (VisualCueInfo)obj.cues.elementAt(i);
            cues_equal = cues1.equals(cues2);
        }
        // Create the return value
        return (cues_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetCues() { return cues; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(cues.size());
            for(int i = 0; i < cues.size(); ++i)
            {
                VisualCueInfo tmp = (VisualCueInfo)cues.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        {
            int len = buf.ReadInt();
            cues.clear();
            for(int j = 0; j < len; ++j)
            {
                VisualCueInfo tmp = new VisualCueInfo();
                tmp.Read(buf);
                cues.addElement(tmp);
            }
        }
        Select(0);
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "cues = {\n";
        for(int i = 0; i < cues.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)cues.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < cues.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddCues(VisualCueInfo obj)
    {
        cues.addElement(new VisualCueInfo(obj));
        Select(0);
    }

    public void ClearCues()
    {
        cues.clear();
        Select(0);
    }

    public void RemoveCues(int index)
    {
        if(index >= 0 && index < cues.size())
        {
            cues.remove(index);
            Select(0);
        }
    }

    public int GetNumCues()
    {
        return cues.size();
    }

    public VisualCueInfo GetCues(int i)
    {
        VisualCueInfo tmp = (VisualCueInfo)cues.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector cues; // vector of VisualCueInfo objects
}

