// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: ViewerClientInformation
//
// Purpose:
//    This class contains information generated for each client
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ViewerClientInformation extends AttributeSubject
{
    private static int ViewerClientInformation_numAdditionalAtts = 2;

    // Enum values
    public final static int OUTPUTFORMAT_NONE = 0;
    public final static int OUTPUTFORMAT_IMAGE = 1;
    public final static int OUTPUTFORMAT_BMP = 2;
    public final static int OUTPUTFORMAT_PNG = 3;
    public final static int OUTPUTFORMAT_JPEG = 4;
    public final static int OUTPUTFORMAT_DATA = 5;
    public final static int OUTPUTFORMAT_VTK = 6;
    public final static int OUTPUTFORMAT_X3D = 7;
    public final static int OUTPUTFORMAT_USERDATA = 8;
    public final static int OUTPUTFORMAT_JSON = 9;
    public final static int OUTPUTFORMAT_MESSAGE = 10;


    public ViewerClientInformation()
    {
        super(ViewerClientInformation_numAdditionalAtts);

        vars = new Vector();
        supportedFormats = new Vector();
        supportedFormats.addElement(new String("None"));
        supportedFormats.addElement(new String("Image"));
        supportedFormats.addElement(new String("BMP"));
        supportedFormats.addElement(new String("PNG"));
        supportedFormats.addElement(new String("JPEG"));
        supportedFormats.addElement(new String("Data"));
        supportedFormats.addElement(new String("VTK"));
        supportedFormats.addElement(new String("X3D"));
        supportedFormats.addElement(new String("UserData"));
        supportedFormats.addElement(new String("JSON"));
        supportedFormats.addElement(new String("Message"));
    }

    public ViewerClientInformation(int nMoreFields)
    {
        super(ViewerClientInformation_numAdditionalAtts + nMoreFields);

        vars = new Vector();
        supportedFormats = new Vector();
        supportedFormats.addElement(new String("None"));
        supportedFormats.addElement(new String("Image"));
        supportedFormats.addElement(new String("BMP"));
        supportedFormats.addElement(new String("PNG"));
        supportedFormats.addElement(new String("JPEG"));
        supportedFormats.addElement(new String("Data"));
        supportedFormats.addElement(new String("VTK"));
        supportedFormats.addElement(new String("X3D"));
        supportedFormats.addElement(new String("UserData"));
        supportedFormats.addElement(new String("JSON"));
        supportedFormats.addElement(new String("Message"));
    }

    public ViewerClientInformation(ViewerClientInformation obj)
    {
        super(obj);

        int i;

        // *** Copy the vars field ***
        vars = new Vector(obj.vars.size());
        for(i = 0; i < obj.vars.size(); ++i)
        {
            ViewerClientInformationElement oldObj = (ViewerClientInformationElement)obj.vars.elementAt(i);
            vars.addElement(new ViewerClientInformationElement(oldObj));
        }

        supportedFormats = new Vector(obj.supportedFormats.size());
        for(i = 0; i < obj.supportedFormats.size(); ++i)
            supportedFormats.addElement(new String((String)obj.supportedFormats.elementAt(i)));


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ViewerClientInformation_numAdditionalAtts;
    }

    public boolean equals(ViewerClientInformation obj)
    {
        int i;

        // Compare the elements in the vars vector.
        boolean vars_equal = (obj.vars.size() == vars.size());
        for(i = 0; (i < vars.size()) && vars_equal; ++i)
        {
            // Make references to ViewerClientInformationElement from Object.
            ViewerClientInformationElement vars1 = (ViewerClientInformationElement)vars.elementAt(i);
            ViewerClientInformationElement vars2 = (ViewerClientInformationElement)obj.vars.elementAt(i);
            vars_equal = vars1.equals(vars2);
        }
        // Compare the elements in the supportedFormats vector.
        boolean supportedFormats_equal = (obj.supportedFormats.size() == supportedFormats.size());
        for(i = 0; (i < supportedFormats.size()) && supportedFormats_equal; ++i)
        {
            // Make references to String from Object.
            String supportedFormats1 = (String)supportedFormats.elementAt(i);
            String supportedFormats2 = (String)obj.supportedFormats.elementAt(i);
            supportedFormats_equal = supportedFormats1.equals(supportedFormats2);
        }
        // Create the return value
        return (vars_equal &&
                supportedFormats_equal);
    }

    // Property setting methods
    public void SetSupportedFormats(Vector supportedFormats_)
    {
        supportedFormats = supportedFormats_;
        Select(1);
    }

    // Property getting methods
    public Vector GetVars() { return vars; }
    public Vector GetSupportedFormats() { return supportedFormats; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(vars.size());
            for(int i = 0; i < vars.size(); ++i)
            {
                ViewerClientInformationElement tmp = (ViewerClientInformationElement)vars.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(1, buf))
            buf.WriteStringVector(supportedFormats);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            {
                int len = buf.ReadInt();
                vars.clear();
                for(int j = 0; j < len; ++j)
                {
                    ViewerClientInformationElement tmp = new ViewerClientInformationElement();
                    tmp.Read(buf);
                    vars.addElement(tmp);
                }
            }
            Select(0);
            break;
        case 1:
            SetSupportedFormats(buf.ReadStringVector());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "vars = {\n";
        for(int i = 0; i < vars.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)vars.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < vars.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + stringVectorToString("supportedFormats", supportedFormats, indent) + "\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddVars(ViewerClientInformationElement obj)
    {
        vars.addElement(new ViewerClientInformationElement(obj));
        Select(0);
    }

    public void ClearVars()
    {
        vars.clear();
        Select(0);
    }

    public void RemoveVars(int index)
    {
        if(index >= 0 && index < vars.size())
        {
            vars.remove(index);
            Select(0);
        }
    }

    public int GetNumVars()
    {
        return vars.size();
    }

    public ViewerClientInformationElement GetVars(int i)
    {
        ViewerClientInformationElement tmp = (ViewerClientInformationElement)vars.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector vars; // vector of ViewerClientInformationElement objects
    private Vector supportedFormats; // vector of String objects
}

