// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: TimeFormat
//
// Purpose:
//    This class encapsulates the attributes needed to format time.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class TimeFormat extends AttributeSubject
{
    private static int TimeFormat_numAdditionalAtts = 2;

    // Enum values
    public final static int DISPLAYMODE_CYCLES = 0;
    public final static int DISPLAYMODE_TIMES = 1;
    public final static int DISPLAYMODE_CYCLESANDTIMES = 2;


    public TimeFormat()
    {
        super(TimeFormat_numAdditionalAtts);

        displayMode = DISPLAYMODE_CYCLES;
        precision = 5;
    }

    public TimeFormat(int nMoreFields)
    {
        super(TimeFormat_numAdditionalAtts + nMoreFields);

        displayMode = DISPLAYMODE_CYCLES;
        precision = 5;
    }

    public TimeFormat(TimeFormat obj)
    {
        super(obj);

        displayMode = obj.displayMode;
        precision = obj.precision;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return TimeFormat_numAdditionalAtts;
    }

    public boolean equals(TimeFormat obj)
    {
        // Create the return value
        return ((displayMode == obj.displayMode) &&
                (precision == obj.precision));
    }

    // Property setting methods
    public void SetDisplayMode(int displayMode_)
    {
        displayMode = displayMode_;
        Select(0);
    }

    public void SetPrecision(int precision_)
    {
        precision = precision_;
        Select(1);
    }

    // Property getting methods
    public int GetDisplayMode() { return displayMode; }
    public int GetPrecision() { return precision; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(displayMode);
        if(WriteSelect(1, buf))
            buf.WriteInt(precision);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetDisplayMode(buf.ReadInt());
            break;
        case 1:
            SetPrecision(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "displayMode = ";
        if(displayMode == DISPLAYMODE_CYCLES)
            str = str + "DISPLAYMODE_CYCLES";
        if(displayMode == DISPLAYMODE_TIMES)
            str = str + "DISPLAYMODE_TIMES";
        if(displayMode == DISPLAYMODE_CYCLESANDTIMES)
            str = str + "DISPLAYMODE_CYCLESANDTIMES";
        str = str + "\n";
        str = str + intToString("precision", precision, indent) + "\n";
        return str;
    }


    // Attributes
    private int displayMode;
    private int precision;
}

