// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: SyncAttributes
//
// Purpose:
//    This class contains an integer that can be used to synchronize the viewer and its clients.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class SyncAttributes extends AttributeSubject
{
    private static int SyncAttributes_numAdditionalAtts = 1;

    public SyncAttributes()
    {
        super(SyncAttributes_numAdditionalAtts);

        syncTag = -1;
    }

    public SyncAttributes(int nMoreFields)
    {
        super(SyncAttributes_numAdditionalAtts + nMoreFields);

        syncTag = -1;
    }

    public SyncAttributes(SyncAttributes obj)
    {
        super(obj);

        syncTag = obj.syncTag;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return SyncAttributes_numAdditionalAtts;
    }

    public boolean equals(SyncAttributes obj)
    {
        // Create the return value
        return ((syncTag == obj.syncTag));
    }

    // Property setting methods
    public void SetSyncTag(int syncTag_)
    {
        syncTag = syncTag_;
        Select(0);
    }

    // Property getting methods
    public int GetSyncTag() { return syncTag; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(syncTag);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetSyncTag(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("syncTag", syncTag, indent) + "\n";
        return str;
    }


    // Attributes
    private int syncTag;
}

