// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: SimulationUIValues
//
// Purpose:
//    Contains UI values from a simulation.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class SimulationUIValues extends AttributeSubject
{
    private static int SimulationUIValues_numAdditionalAtts = 6;

    public SimulationUIValues()
    {
        super(SimulationUIValues_numAdditionalAtts);

        host = new String("");
        sim = new String("");
        name = new String("");
        ivalue = 0;
        svalue = new String("");
        enabled = true;
    }

    public SimulationUIValues(int nMoreFields)
    {
        super(SimulationUIValues_numAdditionalAtts + nMoreFields);

        host = new String("");
        sim = new String("");
        name = new String("");
        ivalue = 0;
        svalue = new String("");
        enabled = true;
    }

    public SimulationUIValues(SimulationUIValues obj)
    {
        super(obj);

        host = new String(obj.host);
        sim = new String(obj.sim);
        name = new String(obj.name);
        ivalue = obj.ivalue;
        svalue = new String(obj.svalue);
        enabled = obj.enabled;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return SimulationUIValues_numAdditionalAtts;
    }

    public boolean equals(SimulationUIValues obj)
    {
        // Create the return value
        return ((host.equals(obj.host)) &&
                (sim.equals(obj.sim)) &&
                (name.equals(obj.name)) &&
                (ivalue == obj.ivalue) &&
                (svalue.equals(obj.svalue)) &&
                (enabled == obj.enabled));
    }

    // Property setting methods
    public void SetHost(String host_)
    {
        host = host_;
        Select(0);
    }

    public void SetSim(String sim_)
    {
        sim = sim_;
        Select(1);
    }

    public void SetName(String name_)
    {
        name = name_;
        Select(2);
    }

    public void SetIvalue(int ivalue_)
    {
        ivalue = ivalue_;
        Select(3);
    }

    public void SetSvalue(String svalue_)
    {
        svalue = svalue_;
        Select(4);
    }

    public void SetEnabled(boolean enabled_)
    {
        enabled = enabled_;
        Select(5);
    }

    // Property getting methods
    public String  GetHost() { return host; }
    public String  GetSim() { return sim; }
    public String  GetName() { return name; }
    public int     GetIvalue() { return ivalue; }
    public String  GetSvalue() { return svalue; }
    public boolean GetEnabled() { return enabled; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(host);
        if(WriteSelect(1, buf))
            buf.WriteString(sim);
        if(WriteSelect(2, buf))
            buf.WriteString(name);
        if(WriteSelect(3, buf))
            buf.WriteInt(ivalue);
        if(WriteSelect(4, buf))
            buf.WriteString(svalue);
        if(WriteSelect(5, buf))
            buf.WriteBool(enabled);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetHost(buf.ReadString());
            break;
        case 1:
            SetSim(buf.ReadString());
            break;
        case 2:
            SetName(buf.ReadString());
            break;
        case 3:
            SetIvalue(buf.ReadInt());
            break;
        case 4:
            SetSvalue(buf.ReadString());
            break;
        case 5:
            SetEnabled(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("host", host, indent) + "\n";
        str = str + stringToString("sim", sim, indent) + "\n";
        str = str + stringToString("name", name, indent) + "\n";
        str = str + intToString("ivalue", ivalue, indent) + "\n";
        str = str + stringToString("svalue", svalue, indent) + "\n";
        str = str + boolToString("enabled", enabled, indent) + "\n";
        return str;
    }


    // Attributes
    private String  host;
    private String  sim;
    private String  name;
    private int     ivalue;
    private String  svalue;
    private boolean enabled;
}

