// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: SimulationCommand
//
// Purpose:
//    Commands to control simulations
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class SimulationCommand extends AttributeSubject
{
    private static int SimulationCommand_numAdditionalAtts = 1;

    public SimulationCommand()
    {
        super(SimulationCommand_numAdditionalAtts);

        command = new String("");
    }

    public SimulationCommand(int nMoreFields)
    {
        super(SimulationCommand_numAdditionalAtts + nMoreFields);

        command = new String("");
    }

    public SimulationCommand(SimulationCommand obj)
    {
        super(obj);

        command = new String(obj.command);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return SimulationCommand_numAdditionalAtts;
    }

    public boolean equals(SimulationCommand obj)
    {
        // Create the return value
        return ((command.equals(obj.command)));
    }

    // Property setting methods
    public void SetCommand(String command_)
    {
        command = command_;
        Select(0);
    }

    // Property getting methods
    public String GetCommand() { return command; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(command);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetCommand(buf.ReadString());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("command", command, indent) + "\n";
        return str;
    }


    // Attributes
    private String command;
}

