// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: PostponedAction
//
// Purpose:
//    This class contains the attributes for controlling the viewer vis a postponed action.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class PostponedAction extends AttributeSubject
{
    private static int PostponedAction_numAdditionalAtts = 2;

    public PostponedAction()
    {
        super(PostponedAction_numAdditionalAtts);

        RPC = new ViewerRPC();
        window = 0;
    }

    public PostponedAction(int nMoreFields)
    {
        super(PostponedAction_numAdditionalAtts + nMoreFields);

        RPC = new ViewerRPC();
        window = 0;
    }

    public PostponedAction(PostponedAction obj)
    {
        super(obj);

        RPC = new ViewerRPC(obj.RPC);
        window = obj.window;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return PostponedAction_numAdditionalAtts;
    }

    public boolean equals(PostponedAction obj)
    {
        // Create the return value
        return ((RPC.equals(obj.RPC)) &&
                (window == obj.window));
    }

    // Property setting methods
    public void SetRPC(ViewerRPC RPC_)
    {
        RPC = RPC_;
        Select(0);
    }

    public void SetWindow(int window_)
    {
        window = window_;
        Select(1);
    }

    // Property getting methods
    public ViewerRPC GetRPC() { return RPC; }
    public int       GetWindow() { return window; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            RPC.Write(buf);
        if(WriteSelect(1, buf))
            buf.WriteInt(window);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            RPC.Read(buf);
            Select(0);
            break;
        case 1:
            SetWindow(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "RPC = {\n" + RPC.toString(indent + "    ") + indent + "}\n";
        str = str + intToString("window", window, indent) + "\n";
        return str;
    }


    // Attributes
    private ViewerRPC RPC;
    private int       window;
}

