// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: PlotInfoAttributes
//
// Purpose:
//    contains info set by the executed plot.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class PlotInfoAttributes extends AttributeSubject
{
    private static int PlotInfoAttributes_numAdditionalAtts = 1;

    public PlotInfoAttributes()
    {
        super(PlotInfoAttributes_numAdditionalAtts);

        data = new MapNode();
    }

    public PlotInfoAttributes(int nMoreFields)
    {
        super(PlotInfoAttributes_numAdditionalAtts + nMoreFields);

        data = new MapNode();
    }

    public PlotInfoAttributes(PlotInfoAttributes obj)
    {
        super(obj);

        data = new MapNode(obj.data);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return PlotInfoAttributes_numAdditionalAtts;
    }

    public boolean equals(PlotInfoAttributes obj)
    {
        // Create the return value
        return ((data.equals(obj.data)));
    }

    // Property setting methods
    public void SetData(MapNode data_)
    {
        data = data_;
        Select(0);
    }

    // Property getting methods
    public MapNode GetData() { return data; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            data.Write(buf);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        data.Read(buf);
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "data = " + data.toString(indent);
        return str;
    }


    // Attributes
    private MapNode data;
}

