// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.lang.Byte;
import java.util.Vector;

// ****************************************************************************
// Class: MessageAttributes
//
// Purpose:
//    This class contains attributes for sending messages.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class MessageAttributes extends AttributeSubject
{
    private static int MessageAttributes_numAdditionalAtts = 4;

    // Enum values
    public final static int SEVERITY_ERROR = 0;
    public final static int SEVERITY_WARNING = 1;
    public final static int SEVERITY_MESSAGE = 2;
    public final static int SEVERITY_ERRORCLEAR = 3;
    public final static int SEVERITY_INFORMATION = 4;


    public MessageAttributes()
    {
        super(MessageAttributes_numAdditionalAtts);

        text = new String("");
        unicode = new Vector();
        hasUnicode = false;
        severity = SEVERITY_MESSAGE;
    }

    public MessageAttributes(int nMoreFields)
    {
        super(MessageAttributes_numAdditionalAtts + nMoreFields);

        text = new String("");
        unicode = new Vector();
        hasUnicode = false;
        severity = SEVERITY_MESSAGE;
    }

    public MessageAttributes(MessageAttributes obj)
    {
        super(obj);

        int i;

        text = new String(obj.text);
        unicode = new Vector(obj.unicode.size());
        for(i = 0; i < obj.unicode.size(); ++i)
        {
            Byte bv = (Byte)obj.unicode.elementAt(i);
            unicode.addElement(new Byte(bv.byteValue()));
        }

        hasUnicode = obj.hasUnicode;
        severity = obj.severity;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return MessageAttributes_numAdditionalAtts;
    }

    public boolean equals(MessageAttributes obj)
    {
        int i;

        // Compare the elements in the unicode vector.
        boolean unicode_equal = (obj.unicode.size() == unicode.size());
        for(i = 0; (i < unicode.size()) && unicode_equal; ++i)
        {
            // Make references to Byte from Object.
            Byte unicode1 = (Byte)unicode.elementAt(i);
            Byte unicode2 = (Byte)obj.unicode.elementAt(i);
            unicode_equal = unicode1.equals(unicode2);
        }
        // Create the return value
        return ((text.equals(obj.text)) &&
                unicode_equal &&
                (hasUnicode == obj.hasUnicode) &&
                (severity == obj.severity));
    }

    // Property setting methods
    public void SetText(String text_)
    {
        text = text_;
        Select(0);
    }

    public void SetUnicode(Vector unicode_)
    {
        unicode = unicode_;
        Select(1);
    }

    public void SetHasUnicode(boolean hasUnicode_)
    {
        hasUnicode = hasUnicode_;
        Select(2);
    }

    public void SetSeverity(int severity_)
    {
        severity = severity_;
        Select(3);
    }

    // Property getting methods
    public String  GetText() { return text; }
    public Vector  GetUnicode() { return unicode; }
    public boolean GetHasUnicode() { return hasUnicode; }
    public int     GetSeverity() { return severity; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(text);
        if(WriteSelect(1, buf))
            buf.WriteByteVector(unicode);
        if(WriteSelect(2, buf))
            buf.WriteBool(hasUnicode);
        if(WriteSelect(3, buf))
            buf.WriteInt(severity);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetText(buf.ReadString());
            break;
        case 1:
            SetUnicode(buf.ReadByteVector());
            break;
        case 2:
            SetHasUnicode(buf.ReadBool());
            break;
        case 3:
            SetSeverity(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("text", text, indent) + "\n";
        str = str + ucharVectorToString("unicode", unicode, indent) + "\n";
        str = str + boolToString("hasUnicode", hasUnicode, indent) + "\n";
        str = str + indent + "severity = ";
        if(severity == SEVERITY_ERROR)
            str = str + "SEVERITY_ERROR";
        if(severity == SEVERITY_WARNING)
            str = str + "SEVERITY_WARNING";
        if(severity == SEVERITY_MESSAGE)
            str = str + "SEVERITY_MESSAGE";
        if(severity == SEVERITY_ERRORCLEAR)
            str = str + "SEVERITY_ERRORCLEAR";
        if(severity == SEVERITY_INFORMATION)
            str = str + "SEVERITY_INFORMATION";
        str = str + "\n";
        return str;
    }


    // Attributes
    private String  text;
    private Vector  unicode; // vector of Byte objects
    private boolean hasUnicode;
    private int     severity;
}

