// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: ColorAttribute
//
// Purpose:
//    This class contains RGBA color information
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ColorAttribute extends AttributeSubject
{
    private static int ColorAttribute_numAdditionalAtts = 1;


    public ColorAttribute()
    {
        super(ColorAttribute_numAdditionalAtts);

        color = new byte[4];
        color[0] = (byte)0;
        color[1] = (byte)0;
        color[2] = (byte)0;
        color[3] = (byte)255;
    }

    public ColorAttribute(int nMoreFields)
    {
        super(ColorAttribute_numAdditionalAtts + nMoreFields);

        color = new byte[4];
        color[0] = (byte)0;
        color[1] = (byte)0;
        color[2] = (byte)0;
        color[3] = (byte)255;
    }

    public ColorAttribute(ColorAttribute obj)
    {
        super(obj);

        int i;

        color = new byte[4];
        for(i = 0; i < obj.color.length; ++i)
            color[i] = obj.color[i];


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ColorAttribute_numAdditionalAtts;
    }

    public boolean equals(ColorAttribute obj)
    {
        int i;

        // Compare the color arrays.
        boolean color_equal = true;
        for(i = 0; i < 4 && color_equal; ++i)
            color_equal = (color[i] == obj.color[i]);

        // Create the return value
        return (color_equal);
    }

    // Property setting methods
    public void SetColor(byte[] color_)
    {
        color[0] = color_[0];
        color[1] = color_[1];
        color[2] = color_[2];
        color[3] = color_[3];
        Select(0);
    }

    public void SetColor(byte e0, byte e1, byte e2, byte e3)
    {
        color[0] = e0;
        color[1] = e1;
        color[2] = e2;
        color[3] = e3;
        Select(0);
    }

    // Property getting methods
    public byte[] GetColor() { return color; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteByteArray(color, true);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetColor(buf.ReadByteArray());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + ucharArrayToString("color", color, indent) + "\n";
        return str;
    }


    public ColorAttribute(int r, int g, int b)
    {
        super(1);
        color = new byte[4];
        color[0] = (byte)(0xff & r);
        color[1] = (byte)(0xff & g);
        color[2] = (byte)(0xff & b);
        color[3] = (byte)(0xff & 255);
    }

    public ColorAttribute(int r, int g, int b, int a)
    {
        super(1);
        color = new byte[4];
        color[0] = (byte)(0xff & r);
        color[1] = (byte)(0xff & g);
        color[2] = (byte)(0xff & b);
        color[3] = (byte)(0xff & a);
    }

    public int Red()
    {
       int mask = 0xff;
       return mask & color[0];
    }

    public int Green()
    {
       int mask = 0xff;
       return mask & color[1];
    }

    public int Blue()
    {
       int mask = 0xff;
       return mask & color[2];
    }

    public int Alpha()
    {
       int mask = 0xff;
       return mask & color[3];
    }

    // Attributes
    private byte[] color;
}

