// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: AxesArray
//
// Purpose:
//    Contains the properties for the array axes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class AxesArray extends AttributeSubject
{
    private static int AxesArray_numAdditionalAtts = 6;

    public AxesArray()
    {
        super(AxesArray_numAdditionalAtts);

        visible = true;
        ticksVisible = true;
        autoSetTicks = true;
        autoSetScaling = true;
        lineWidth = 0;
        axes = new AxisAttributes();
    }

    public AxesArray(int nMoreFields)
    {
        super(AxesArray_numAdditionalAtts + nMoreFields);

        visible = true;
        ticksVisible = true;
        autoSetTicks = true;
        autoSetScaling = true;
        lineWidth = 0;
        axes = new AxisAttributes();
    }

    public AxesArray(AxesArray obj)
    {
        super(obj);

        visible = obj.visible;
        ticksVisible = obj.ticksVisible;
        autoSetTicks = obj.autoSetTicks;
        autoSetScaling = obj.autoSetScaling;
        lineWidth = obj.lineWidth;
        axes = new AxisAttributes(obj.axes);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return AxesArray_numAdditionalAtts;
    }

    public boolean equals(AxesArray obj)
    {
        // Create the return value
        return ((visible == obj.visible) &&
                (ticksVisible == obj.ticksVisible) &&
                (autoSetTicks == obj.autoSetTicks) &&
                (autoSetScaling == obj.autoSetScaling) &&
                (lineWidth == obj.lineWidth) &&
                (axes.equals(obj.axes)));
    }

    // Property setting methods
    public void SetVisible(boolean visible_)
    {
        visible = visible_;
        Select(0);
    }

    public void SetTicksVisible(boolean ticksVisible_)
    {
        ticksVisible = ticksVisible_;
        Select(1);
    }

    public void SetAutoSetTicks(boolean autoSetTicks_)
    {
        autoSetTicks = autoSetTicks_;
        Select(2);
    }

    public void SetAutoSetScaling(boolean autoSetScaling_)
    {
        autoSetScaling = autoSetScaling_;
        Select(3);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(4);
    }

    public void SetAxes(AxisAttributes axes_)
    {
        axes = axes_;
        Select(5);
    }

    // Property getting methods
    public boolean        GetVisible() { return visible; }
    public boolean        GetTicksVisible() { return ticksVisible; }
    public boolean        GetAutoSetTicks() { return autoSetTicks; }
    public boolean        GetAutoSetScaling() { return autoSetScaling; }
    public int            GetLineWidth() { return lineWidth; }
    public AxisAttributes GetAxes() { return axes; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(visible);
        if(WriteSelect(1, buf))
            buf.WriteBool(ticksVisible);
        if(WriteSelect(2, buf))
            buf.WriteBool(autoSetTicks);
        if(WriteSelect(3, buf))
            buf.WriteBool(autoSetScaling);
        if(WriteSelect(4, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(5, buf))
            axes.Write(buf);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetVisible(buf.ReadBool());
            break;
        case 1:
            SetTicksVisible(buf.ReadBool());
            break;
        case 2:
            SetAutoSetTicks(buf.ReadBool());
            break;
        case 3:
            SetAutoSetScaling(buf.ReadBool());
            break;
        case 4:
            SetLineWidth(buf.ReadInt());
            break;
        case 5:
            axes.Read(buf);
            Select(5);
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("visible", visible, indent) + "\n";
        str = str + boolToString("ticksVisible", ticksVisible, indent) + "\n";
        str = str + boolToString("autoSetTicks", autoSetTicks, indent) + "\n";
        str = str + boolToString("autoSetScaling", autoSetScaling, indent) + "\n";
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + indent + "axes = {\n" + axes.toString(indent + "    ") + indent + "}\n";
        return str;
    }


    // Attributes
    private boolean        visible;
    private boolean        ticksVisible;
    private boolean        autoSetTicks;
    private boolean        autoSetScaling;
    private int            lineWidth;
    private AxisAttributes axes;
}

