// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisSeedMeWindow.h"

#include <SeedMeAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QCloseEvent>
#include <QRadioButton>
#include <QTabWidget>
#include <QTextBrowser>
#include <QScrollBar>
#include <QFormLayout>
#include <QPushButton>
#include <QFileSystemWatcher>
#include <QTextStream>
#include <QComboBox>

#include <InstallationFunctions.h>

#include <QFileDialog>
#include <QDir>


#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisSeedMeWindow::QvisSeedMeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSeedMeWindow::QvisSeedMeWindow(
                         SeedMeAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisPostableWindowSimpleObserver(caption, shortName, notepad, 0, false)
{
    atts = subj;
    atts->Attach(this);

    configFile = GetDefaultConfigFile("seedme_apikey_path", "VISITHOME");
    QFile settings_file(configFile);
    if(settings_file.exists() && (settings_file.open(QIODevice::ReadOnly | QIODevice::Text)))
    {
        QTextStream in(&settings_file);
        apikeyFile = in.readLine();
        settings_file.close();
    }
    else
    {
        apikeyFile = QDir::homePath()+"/seedme.txt";
    }
}

// ****************************************************************************
// Method: QvisSeedMeWindow::~QvisSeedMeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSeedMeWindow::~QvisSeedMeWindow()
{
    if(atts != NULL)
       atts->Detach(this);
}

void
QvisSeedMeWindow::SubjectRemoved(Subject *subj)
{
    if(atts == subj)
        atts = NULL;
}

void
QvisSeedMeWindow::browse()
{
    QStringList filesList = QFileDialog::getOpenFileNames(this,
                            tr("Find Files"), QDir::currentPath());
    if(!filesList.isEmpty())
    {
        uploadFiles = filesList;
        updateStatus("Set to upload:\n"+filesList.join("\n"));
    }
}

void
QvisSeedMeWindow::browseApiKey()
{
    QString file = QFileDialog::getOpenFileName(this,
                            tr("Find File"), QDir::currentPath());
    if(!file.isEmpty())
    {
        QFileInfo apikeyFileInfo1(apikeyFile);
        seedmeWatcher->removePath(apikeyFileInfo1.dir().path());
        apikeyFile = file;
        QFileInfo apikeyFileInfo2(apikeyFile);
        seedmeWatcher->addPath(apikeyFileInfo2.dir().path());
        helpLabelWarning->setText("<b>The file "+apikeyFile+" is not found.<br>Please download the file with your credentials.</b>");
        helpLabelWarning->setVisible(false);
        QFile settingsFile(configFile);
        if (settingsFile.open(QIODevice::ReadWrite))
        {
            QTextStream stream(&settingsFile);
            stream << apikeyFile << endl;
            settingsFile.close();
        }
        confLocationLabel->setText("Using "+apikeyFile+" for seedme APIKey file.");

    }
}

// ****************************************************************************
// Method: QvisSeedMeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSeedMeWindow::CreateWindowContents()
{
    tabs = new QTabWidget(central);
    topLayout->addWidget(tabs);

    tabs->addTab(CreateQuickUploadTab(), tr("Quick Video"));
    tabs->addTab(CreateUploadTab(), tr("Upload"));
    tabs->addTab(CreateQueryTab(), tr("Query"));
    tabs->addTab(CreateDownloadTab(), tr("Download"));
    tabs->addTab(CreateSettingsTab(), tr("Settings"));

    statusLabel = new QTextBrowser(central);
    topLayout->addWidget(statusLabel);

    submitButton = new QPushButton("Submit");
    topLayout->addWidget(submitButton);
    connect(submitButton, SIGNAL (clicked()), this, SLOT (apply()));

    resetFormButton = new QPushButton("Reset form");
    topLayout->addWidget(resetFormButton);
    connect(resetFormButton, SIGNAL (clicked()), this, SLOT (ResetForm()));

    clearLogButton = new QPushButton("Clear log");
    topLayout->addWidget(clearLogButton);
    connect(clearLogButton, SIGNAL (clicked()), this, SLOT (ClearLog()));
}

QWidget *
QvisSeedMeWindow::CreateQuickUploadTab()
{
    QWidget *w = new QWidget(0);
    QFormLayout *mainLayout = new QFormLayout(w);

    quickSharing = new QWidget(central);
    quickSharingButtonGroup= new QButtonGroup(quickSharing);
    QHBoxLayout *quickSharingLayout = new QHBoxLayout(quickSharing);
    quickSharingLayout->setMargin(0);
    quickSharingLayout->setSpacing(10);
    QRadioButton *quickSharingSharingSHARING_PRIVATE = new QRadioButton(tr("PRIVATE"), quickSharing);
    quickSharingButtonGroup->addButton(quickSharingSharingSHARING_PRIVATE,0);
    quickSharingLayout->addWidget(quickSharingSharingSHARING_PRIVATE);
    QRadioButton *quickSharingSharingSHARING_GROUP = new QRadioButton(tr("GROUP"), quickSharing);
    quickSharingButtonGroup->addButton(quickSharingSharingSHARING_GROUP,1);
    quickSharingLayout->addWidget(quickSharingSharingSHARING_GROUP);
    QRadioButton *quickSharingSharingSHARING_PUBLIC = new QRadioButton(tr("PUBLIC"), quickSharing);
    quickSharingButtonGroup->addButton(quickSharingSharingSHARING_PUBLIC,2);
    quickSharingLayout->addWidget(quickSharingSharingSHARING_PUBLIC);
    connect(quickSharingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(quickSharingChanged(int)));
    mainLayout->addRow(tr("Sharing"), quickSharing);

    quickCollectionTitle = new QLineEdit(central);
    connect(quickCollectionTitle, SIGNAL(returnPressed()),
            this, SLOT(quickCollectionTitleProcessText()));
    mainLayout->addRow(tr("Collection title"), quickCollectionTitle);
    quickCollectionTitle->setPlaceholderText("Required");

    quickCollectionEmails = new QLineEdit(central);
    connect(quickCollectionEmails, SIGNAL(returnPressed()),
            this, SLOT(quickCollectionEmailsProcessText()));
    mainLayout->addRow(tr("Share emails"), quickCollectionEmails);

    quickFrameRate = new QLineEdit(central);
    connect(quickFrameRate, SIGNAL(returnPressed()),
            this, SLOT(quickFrameRateProcessText()));
    mainLayout->addRow(tr("Frame rate"), quickFrameRate);

    QPushButton* button = new QPushButton("Browse");
    connect(button, SIGNAL(clicked()), SLOT(browse()));
    mainLayout->addRow(tr("Choose image(s) to upload"), button);

    quickDownloadType = new QComboBox(central);
    quickDownloadType->addItem(tr("ALL"));
    quickDownloadType->addItem(tr("BEST"));
    quickDownloadType->addItem(tr("HIGHEST"));
    quickDownloadType->addItem(tr("HIGH"));
    quickDownloadType->addItem(tr("MEDIUM"));
    quickDownloadType->addItem(tr("LOW"));
    quickDownloadType->addItem(tr("LOWEST"));

    connect(quickDownloadType, SIGNAL(activated(int)),
            this, SLOT(quickDownloadTypeChanged(int)));
    mainLayout->addRow(tr("Quality"), quickDownloadType);

    quickDownloadButton = new QPushButton("Download video");
    mainLayout->addRow(quickDownloadButton);
    connect(quickDownloadButton, SIGNAL (clicked()), this, SLOT (quickDownload()));

    quickDownloadType->setDisabled(atts->GetCollectionID() <= 0);
    quickDownloadButton->setDisabled(atts->GetCollectionID() <= 0);

    quickCollectionsLink = new QLabel(tr("<a href=\"https://www.seedme.org/collections/\">SeedMe collections</a>"), w);
    quickCollectionsLink->setTextFormat(Qt::RichText);
    quickCollectionsLink->setTextInteractionFlags(Qt::TextBrowserInteraction);
    quickCollectionsLink->setOpenExternalLinks(true);
    mainLayout->addRow(quickCollectionsLink);

    return w;
}

QWidget *
QvisSeedMeWindow::CreateUploadTab()
{
    QWidget *w = new QWidget(0);
    QGridLayout *mainLayout = new QGridLayout(w);

    // add new group box
    collectionModeLabel = new QLabel(tr("Collection mode"), w);
    mainLayout->addWidget(collectionModeLabel,0,0);
    collectionMode = new QWidget(w);
    collectionModeButtonGroup= new QButtonGroup(collectionMode);
    QHBoxLayout *collectionModeLayout = new QHBoxLayout(collectionMode);
    collectionModeLayout->setMargin(0);
    collectionModeLayout->setSpacing(10);
    QRadioButton *collectionModeCollectionModeCOLLECTION_NEW = new QRadioButton(tr("New"), collectionMode);
    collectionModeButtonGroup->addButton(collectionModeCollectionModeCOLLECTION_NEW,0);
    collectionModeLayout->addWidget(collectionModeCollectionModeCOLLECTION_NEW);
    QRadioButton *collectionModeCollectionModeCOLLECTION_UPDATE = new QRadioButton(tr("Update existing"), collectionMode);
    collectionModeButtonGroup->addButton(collectionModeCollectionModeCOLLECTION_UPDATE,1);
    collectionModeLayout->addWidget(collectionModeCollectionModeCOLLECTION_UPDATE);
    connect(collectionModeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(collectionModeChanged(int)));
    mainLayout->addWidget(collectionMode, 0,1);

    collectionIDLabel = new QLabel(tr("Collection ID"), w);
    mainLayout->addWidget(collectionIDLabel,1,0);
    collectionID = new QLineEdit(w);
    collectionID->setDisabled(true);
    collectionID->setPlaceholderText("Enter collection's ID for update");
    collectionIDLabel->setDisabled(true);
    connect(collectionID, SIGNAL(returnPressed()),
            this, SLOT(collectionIDProcessText()));
    mainLayout->addWidget(collectionID, 1,1);

    // add new group box
    collectionTitleLabel = new QLabel(tr("Collection title"), w);
    mainLayout->addWidget(collectionTitleLabel,2,0);
    collectionTitle = new QLineEdit(w);
    collectionTitle->setPlaceholderText("Required");
    connect(collectionTitle, SIGNAL(returnPressed()),
            this, SLOT(collectionTitleProcessText()));
    mainLayout->addWidget(collectionTitle, 2,1);

    collectionDescriptionLabel = new QLabel(tr("Collection description"), w);
    mainLayout->addWidget(collectionDescriptionLabel,3,0);
    collectionDescription = new QLineEdit(w);
    connect(collectionDescription, SIGNAL(returnPressed()),
            this, SLOT(collectionDescriptionProcessText()));
    mainLayout->addWidget(collectionDescription, 3,1);

    sharingLabel = new QLabel(tr("Sharing"), w);
    mainLayout->addWidget(sharingLabel,4,0);
    sharing = new QWidget(w);
    sharingButtonGroup= new QButtonGroup(sharing);
    QHBoxLayout *sharingLayout = new QHBoxLayout(sharing);
    sharingLayout->setMargin(0);
    sharingLayout->setSpacing(10);
    QRadioButton *sharingSharingSHARING_PRIVATE = new QRadioButton(tr("PRIVATE"), sharing);
    sharingButtonGroup->addButton(sharingSharingSHARING_PRIVATE,0);
    sharingLayout->addWidget(sharingSharingSHARING_PRIVATE);
    QRadioButton *sharingSharingSHARING_GROUP = new QRadioButton(tr("GROUP"), sharing);
    sharingButtonGroup->addButton(sharingSharingSHARING_GROUP,1);
    sharingLayout->addWidget(sharingSharingSHARING_GROUP);
    QRadioButton *sharingSharingSHARING_PUBLIC = new QRadioButton(tr("PUBLIC"), sharing);
    sharingButtonGroup->addButton(sharingSharingSHARING_PUBLIC,2);
    sharingLayout->addWidget(sharingSharingSHARING_PUBLIC);
    connect(sharingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(sharingChanged(int)));
    mainLayout->addWidget(sharing, 4,1);

    collectionEmailsLabel = new QLabel(tr("Share emails"), w);
    mainLayout->addWidget(collectionEmailsLabel,5,0);
    collectionEmails = new QLineEdit(w);
    connect(collectionEmails, SIGNAL(returnPressed()),
            this, SLOT(collectionEmailsProcessText()));
    mainLayout->addWidget(collectionEmails, 5,1);
    collectionEmailsLabel->setDisabled(true);
    collectionEmails->setDisabled(true);
    collectionEmails->setPlaceholderText("Enter space separated emails for sharing");

    keyValueLabel = new QLabel(tr("Key-values"), central);
    mainLayout->addWidget(keyValueLabel,6,0);
    keyValue = new QLineEdit(central);
    connect(keyValue, SIGNAL(returnPressed()),
            this, SLOT(keyValueProcessText()));
    mainLayout->addWidget(keyValue, 6,1);
    keyValue->setPlaceholderText("Example: \"a:b\" \"c:d\"");

    overwriteFiles = new QCheckBox(tr("Overwrite files"), w);
    connect(overwriteFiles, SIGNAL(toggled(bool)),
            this, SLOT(overwriteFilesChanged(bool)));
    mainLayout->addWidget(overwriteFiles, 9,0);

    // add new group box
    QLabel* label = new QLabel("Choose file(s) to upload");
    QPushButton* button = new QPushButton("Browse");
    connect(button, SIGNAL(clicked()), SLOT(browse()));
    mainLayout->addWidget(label, 10,0);
    mainLayout->addWidget(button, 10,1);

    // add new group box
    uploadSequenceFile = new QCheckBox(tr("Upload as image sequence"), w);
    connect(uploadSequenceFile, SIGNAL(toggled(bool)),
            this, SLOT(uploadSequenceFileChanged(bool)));
    mainLayout->addWidget(uploadSequenceFile, 11,0);

    sequenceTitleLabel = new QLabel(tr("Sequence title"), w);
    mainLayout->addWidget(sequenceTitleLabel,12,0);
    sequenceTitle = new QLineEdit(w);
    sequenceTitle->setPlaceholderText("Required");
    connect(sequenceTitle, SIGNAL(returnPressed()),
            this, SLOT(sequenceTitleProcessText()));
    mainLayout->addWidget(sequenceTitle, 12,1);

    sequenceDescriptionLabel = new QLabel(tr("Sequence description"), w);
    mainLayout->addWidget(sequenceDescriptionLabel,13,0);
    sequenceDescription = new QLineEdit(w);
    connect(sequenceDescription, SIGNAL(returnPressed()),
            this, SLOT(sequenceDescriptionProcessText()));
    mainLayout->addWidget(sequenceDescription, 13,1);

    sequenceTitle->setDisabled(true);
    sequenceTitleLabel->setDisabled(true);
    sequenceDescription->setDisabled(true);
    sequenceDescriptionLabel->setDisabled(true);

    createVideo = new QCheckBox(tr("Create video from sequence"), w);
    connect(createVideo, SIGNAL(toggled(bool)),
            this, SLOT(createVideoChanged(bool)));
    mainLayout->addWidget(createVideo, 14,0);
    createVideo->setDisabled(true);

    frameRateLabel = new QLabel(tr("Frame rate"), w);
    mainLayout->addWidget(frameRateLabel,15,0);
    frameRate = new QLineEdit(w);
    frameRate->setDisabled(true);
    frameRateLabel->setDisabled(true);
    connect(frameRate, SIGNAL(returnPressed()),
            this, SLOT(frameRateProcessText()));
    mainLayout->addWidget(frameRate, 15,1);

    collectionsLink = new QLabel(tr("<a href=\"https://www.seedme.org/collections/\">SeedMe collections</a>"), w);
    collectionsLink->setTextFormat(Qt::RichText);
    collectionsLink->setTextInteractionFlags(Qt::TextBrowserInteraction);
    collectionsLink->setOpenExternalLinks(true);
    mainLayout->addWidget(collectionsLink, 18,0);

    return w;
}

QWidget *
QvisSeedMeWindow::CreateQueryTab()
{
    QWidget *w = new QWidget(0);
    QFormLayout *mainLayout = new QFormLayout(w);

    queryActionLabel = new QLabel(tr("Action"), central);
    queryAction = new QWidget(central);
    queryActionButtonGroup= new QButtonGroup(queryAction);
    QHBoxLayout *queryActionLayout = new QHBoxLayout(queryAction);
    queryActionLayout->setMargin(0);
    queryActionLayout->setSpacing(10);
    QRadioButton *queryActionQueryActionLIST_COL = new QRadioButton(tr("List"), queryAction);
    queryActionButtonGroup->addButton(queryActionQueryActionLIST_COL,0);
    queryActionLayout->addWidget(queryActionQueryActionLIST_COL);
    QRadioButton *queryActionQueryActionFIND_COL = new QRadioButton(tr("Find"), queryAction);
    queryActionButtonGroup->addButton(queryActionQueryActionFIND_COL,1);
    queryActionLayout->addWidget(queryActionQueryActionFIND_COL);
    QRadioButton *queryActionQueryActionQUERY_COL = new QRadioButton(tr("Query"), queryAction);
    queryActionButtonGroup->addButton(queryActionQueryActionQUERY_COL,2);
    queryActionLayout->addWidget(queryActionQueryActionQUERY_COL);
    connect(queryActionButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(queryActionChanged(int)));
    mainLayout->addRow(queryActionLabel, queryAction);

    queryKeyValueLabel = new QLabel(tr("Key:Value"), central);
    queryKeyValue = new QLineEdit(central);
    queryKeyValue->setPlaceholderText("Example a:b");
    connect(queryKeyValue, SIGNAL(returnPressed()),
            this, SLOT(queryKeyValueProcessText()));
    mainLayout->addRow(queryKeyValueLabel, queryKeyValue);
    queryKeyValue->setDisabled(true);
    queryKeyValueLabel->setDisabled(true);

    queryColIDLabel = new QLabel(tr("Collection ID"), central);
    queryColID = new QLineEdit(central);
    queryColID->setPlaceholderText("Required");
    connect(queryColID, SIGNAL(returnPressed()),
            this, SLOT(queryColIDProcessText()));
    mainLayout->addRow(queryColIDLabel, queryColID);
    queryColID->setDisabled(true);
    queryColIDLabel->setDisabled(true);

    queryCollectionValuesLabel = new QLabel(tr("Return values"), central);
    queryCollectionValues = new QWidget(central);
    queryCollectionValuesButtonGroup= new QButtonGroup(queryCollectionValues);
    QHBoxLayout *queryCollectionValuesLayout = new QHBoxLayout(queryCollectionValues);
    queryCollectionValuesLayout->setMargin(0);
    queryCollectionValuesLayout->setSpacing(10);
    QRadioButton *queryCollectionValuesQueryCollectionValuesQUERY_ALL = new QRadioButton(tr("All"), queryCollectionValues);
    queryCollectionValuesButtonGroup->addButton(queryCollectionValuesQueryCollectionValuesQUERY_ALL,0);
    queryCollectionValuesLayout->addWidget(queryCollectionValuesQueryCollectionValuesQUERY_ALL);
    QRadioButton *queryCollectionValuesQueryCollectionValuesQUERY_KEY_VALUE = new QRadioButton(tr("Key-Values"), queryCollectionValues);
    queryCollectionValuesButtonGroup->addButton(queryCollectionValuesQueryCollectionValuesQUERY_KEY_VALUE,1);
    queryCollectionValuesLayout->addWidget(queryCollectionValuesQueryCollectionValuesQUERY_KEY_VALUE);
    QRadioButton *queryCollectionValuesQueryCollectionValuesQUERY_TICKER = new QRadioButton(tr("Tickers"), queryCollectionValues);
    queryCollectionValuesButtonGroup->addButton(queryCollectionValuesQueryCollectionValuesQUERY_TICKER,2);
    queryCollectionValuesLayout->addWidget(queryCollectionValuesQueryCollectionValuesQUERY_TICKER);
    QRadioButton *queryCollectionValuesQueryCollectionValuesQUERY_URL = new QRadioButton(tr("URL"), queryCollectionValues);
    queryCollectionValuesButtonGroup->addButton(queryCollectionValuesQueryCollectionValuesQUERY_URL,3);
    queryCollectionValuesLayout->addWidget(queryCollectionValuesQueryCollectionValuesQUERY_URL);
    connect(queryCollectionValuesButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(queryCollectionValuesChanged(int)));
    mainLayout->addRow(queryCollectionValuesLabel, queryCollectionValues);
    queryCollectionValues->setDisabled(true);
    queryCollectionValuesLabel->setDisabled(true);

    return w;
}

QWidget *
QvisSeedMeWindow::CreateDownloadTab()
{
    QWidget *w = new QWidget(0);
    QFormLayout *mainLayout = new QFormLayout(w);

    downloadCollectionID = new QLineEdit(central);
    downloadCollectionID->setPlaceholderText("Required");
    mainLayout->addRow(tr("Download collection id"), downloadCollectionID);
    connect(downloadCollectionID, SIGNAL(returnPressed()),
            this, SLOT(downloadCollectionIDProcessText()));

    downloadType = new QWidget(central);
    downloadTypeButtonGroup= new QButtonGroup(downloadType);
    QHBoxLayout *downloadTypeLayout = new QHBoxLayout(downloadType);
    downloadTypeLayout->setMargin(0);
    downloadTypeLayout->setSpacing(10);
    QRadioButton *downloadTypeDownloadDOWNLOAD_ALL = new QRadioButton(tr("Download all"), downloadType);
    downloadTypeButtonGroup->addButton(downloadTypeDownloadDOWNLOAD_ALL,0);
    downloadTypeLayout->addWidget(downloadTypeDownloadDOWNLOAD_ALL);
    QRadioButton *downloadTypeDownloadDOWNLOAD_VIDEO = new QRadioButton(tr("Download video"), downloadType);
    downloadTypeButtonGroup->addButton(downloadTypeDownloadDOWNLOAD_VIDEO,1);
    downloadTypeLayout->addWidget(downloadTypeDownloadDOWNLOAD_VIDEO);
    QRadioButton *downloadTypeDownloadDOWNLOAD_NAME = new QRadioButton(tr("Specify pattern"), downloadType);
    downloadTypeButtonGroup->addButton(downloadTypeDownloadDOWNLOAD_NAME,2);
    downloadTypeLayout->addWidget(downloadTypeDownloadDOWNLOAD_NAME);
    connect(downloadTypeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(downloadTypeChanged(int)));
    mainLayout->addRow(tr("Files:"), downloadType);

    downloadName = new QLineEdit(central);
    connect(downloadName, SIGNAL(returnPressed()),
            this, SLOT(downloadNameProcessText()));
    mainLayout->addRow(tr("Pattern"), downloadName);
    downloadName->setDisabled(true);

    return w;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Biagas, Mon Aug 14 10:43:08 MST 2017
//    Added clearTabsOnClose.
//
// ****************************************************************************

QWidget *
QvisSeedMeWindow::CreateSettingsTab()
{
    QWidget *w = new QWidget(0);
    QGridLayout *mainLayout = new QGridLayout(w);
    helpLabel = new QLabel("<p>To use SeedMe, download your APIKey file for your account,<br>then move this file to your home folder.<br>See <a href=\"https://www.seedme.org/help\">online help</a> for more details.</p>", w);
    helpLabel->setTextFormat(Qt::RichText);
    helpLabel->setTextInteractionFlags(Qt::TextBrowserInteraction);
    helpLabel->setOpenExternalLinks(true);
    mainLayout->addWidget(helpLabel,0,0);

    helpLabelWarning = new QLabel("<b>The file "+apikeyFile+" is not found.<br>Please download the file with your credentials.</b>", w);
    mainLayout->addWidget(helpLabelWarning,1,0);
    helpLabelWarning->setVisible(false);

    confLocationLabel = new QLabel("Using "+apikeyFile+" for seedme APIKey file.");
    mainLayout->addWidget(confLocationLabel,2,0);

    seedmeWatcher = new QFileSystemWatcher(this);
    connect(seedmeWatcher, SIGNAL(directoryChanged(const QString &)), this, SLOT(directoryChanged(const QString &)));

    QFileInfo apikeyFileInfo(apikeyFile);
    seedmeWatcher->addPath(apikeyFileInfo.dir().path());

    QFileInfo checkFile(apikeyFile);
    helpLabelWarning->setVisible(!(checkFile.exists() && checkFile.isFile()));

    QLabel* label = new QLabel("Choose the location of seedme apikey file");
    QPushButton* button = new QPushButton("Browse");
    connect(button, SIGNAL(clicked()), SLOT(browseApiKey()));
    mainLayout->addWidget(label, 3,0);
    mainLayout->addWidget(button, 3,1);

    clearTabsOnClose = new QCheckBox(tr("Clear all tabs on close"),w);
    connect(clearTabsOnClose, SIGNAL(toggled(bool)),
            this, SLOT(clearTabsOnCloseChanged(bool)));
    mainLayout->addWidget(clearTabsOnClose, 4,0);

    return w;
}

void QvisSeedMeWindow::directoryChanged(const QString & path)
{
    QFileInfo checkFile(apikeyFile);
    helpLabelWarning->setVisible(!(checkFile.exists() && checkFile.isFile()));
}

// ****************************************************************************
//  Method: QvisSeedMeWindow::hide
//
//  Purpose:
//    Override default method so that forms may be cleared.
//
//    Programmer: Kathleen Biagas
//    Creation:   August 14, 2017
//
//  Modifications:
//
// ****************************************************************************

void
QvisSeedMeWindow::hide()
{
    if (clearTabsOnClose->isChecked())
    {
        for (int i = 0; i < tabs->count(); ++i)
            this->ResetForm2(tabs->currentIndex());
        this->ClearLog();
    }
    QvisPostableWindow::hide();
}

// ****************************************************************************
//  Method: QvisSeedMeWindow::closeEvent
//
//  Purpose:
//    Override default method so that forms may be cleared.
//
//    Programmer: Kathleen Biagas
//    Creation:   August 14, 2017
//
//  Modifications:
//
// ****************************************************************************

void 
QvisSeedMeWindow::closeEvent(QCloseEvent *event)
{
    if (clearTabsOnClose->isChecked())
    {
        for (int i = 0; i < tabs->count(); ++i)
            this->ResetForm2(tabs->currentIndex());
        this->ClearLog();
    }
    event->accept();
}

void
QvisSeedMeWindow::ResetForm()
{
    this->ResetForm2(tabs->currentIndex());
}

void
QvisSeedMeWindow::ResetForm2(int index)
{
    switch(index)
    {
      case 0: // QuickUpload
      {
        this->quickSharingButtonGroup->button(0)->click();
        this->quickCollectionTitle->setText("");
        this->quickCollectionEmails->setText("");
        this->quickFrameRate->setText("10");
        break;
      }
      case 1: // Upload
      {
        this->sharingButtonGroup->button(0)->click();
        this->collectionModeButtonGroup->button(0)->click();
        this->overwriteFiles->setChecked(false);
        this->uploadSequenceFile->setChecked(false);
        this->createVideo->setChecked(false);
        this->collectionID->setText("0");
        this->collectionTitle->setText("");
        this->collectionDescription->setText("");
        this->collectionEmails->setText("");
        this->keyValue->setText("");
        this->uploadFiles.clear();
        this->sequenceTitle->setText("");
        this->sequenceDescription->setText("");
        this->frameRate->setText("30");
        break;
      }
      case 2: // Query
      {
        this->queryKeyValue->setText("");
        this->queryColID->setText("");
        this->queryCollectionValuesButtonGroup->button(0)->click();
        this->queryActionButtonGroup->button(0)->click();
        break;
      }
      case 3: // Download
      {
        this->downloadTypeButtonGroup->button(0)->click();
        this->downloadCollectionID->setText("0");
        this->downloadName->setText("*");
        break;
      }
      case 4: // Help
      {
        break;
      }
    }
}

void
QvisSeedMeWindow::ClearLog()
{
    this->statusLabel->setText("");
}

// ****************************************************************************
// Method: QvisSeedMeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//    Kathleen Biagas, Mon Aug 14 10:43:08 MST 2017
//    Added clearTabsOnClose.
//   
// ****************************************************************************

void
QvisSeedMeWindow::UpdateWindow(bool doAll)
{
    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case SeedMeAttributes::ID_collectionMode:
            collectionModeButtonGroup->blockSignals(true);
            if(collectionModeButtonGroup->button((int)atts->GetCollectionMode()) != 0)
                collectionModeButtonGroup->button((int)atts->GetCollectionMode())->setChecked(true);
            collectionModeButtonGroup->blockSignals(false);
            break;
          case SeedMeAttributes::ID_collectionID:
            collectionID->setText(IntToQString(atts->GetCollectionID()));
            break;
          case SeedMeAttributes::ID_sharing:
            sharingButtonGroup->blockSignals(true);
            if(sharingButtonGroup->button((int)atts->GetSharing()) != 0)
                sharingButtonGroup->button((int)atts->GetSharing())->setChecked(true);
            sharingButtonGroup->blockSignals(false);
            break;
          case SeedMeAttributes::ID_collectionTitle:
            collectionTitle->setText(QString(atts->GetCollectionTitle().c_str()));
            break;
          case SeedMeAttributes::ID_collectionDescription:
            collectionDescription->setText(QString(atts->GetCollectionDescription().c_str()));
            break;
            break;
          case SeedMeAttributes::ID_collectionEmails:
            collectionEmails->setText(QString(atts->GetCollectionEmails().c_str()));
            break;
          case SeedMeAttributes::ID_overwriteFiles:
            overwriteFiles->blockSignals(true);
            overwriteFiles->setChecked(atts->GetOverwriteFiles());
            overwriteFiles->blockSignals(false);
            break;
          case SeedMeAttributes::ID_keyValue:
            keyValue->setText(QString(atts->GetKeyValue().c_str()));
            break;
          case SeedMeAttributes::ID_uploadSequenceFile:
            uploadSequenceFile->blockSignals(true);
            uploadSequenceFile->setChecked(atts->GetUploadSequenceFile());
            uploadSequenceFile->blockSignals(false);
            break;
          case SeedMeAttributes::ID_sequenceTitle:
            sequenceTitle->setText(QString(atts->GetSequenceTitle().c_str()));
            break;
          case SeedMeAttributes::ID_sequenceDescription:
            sequenceDescription->setText(QString(atts->GetSequenceDescription().c_str()));
            break;
          case SeedMeAttributes::ID_createVideo:
            createVideo->blockSignals(true);
            createVideo->setChecked(atts->GetCreateVideo());
            createVideo->blockSignals(false);
            break;
          case SeedMeAttributes::ID_frameRate:
            frameRate->setText(IntToQString(atts->GetFrameRate()));
            break;
          case SeedMeAttributes::ID_operationResult:
            if(!atts->GetOperationResult().empty())
            {
                updateStatus("Result of operation: "+QString(atts->GetOperationResult().c_str()));
                if(atts->GetCollectionID() > 0)
                {
                    collectionsLink->setText(QString("<a href=\"https://www.seedme.org/node/")+QString::number(atts->GetCollectionID())+
                    QString("\">SeedMe collection ")+QString::number(atts->GetCollectionID())+QString("</a>"));
                    quickCollectionsLink->setText(QString("<a href=\"https://www.seedme.org/node/")+QString::number(atts->GetCollectionID())+
                    QString("\">SeedMe collection ")+QString::number(atts->GetCollectionID())+QString("</a>"));
                    quickDownloadType->setDisabled(false);
                    quickDownloadButton->setDisabled(false);
                }
            }
            break;
          case SeedMeAttributes::ID_queryAction:
            queryActionButtonGroup->blockSignals(true);
            if(queryActionButtonGroup->button((int)atts->GetQueryAction()) != 0)
                queryActionButtonGroup->button((int)atts->GetQueryAction())->setChecked(true);
            queryActionButtonGroup->blockSignals(false);
            break;
          case SeedMeAttributes::ID_queryColID:
            queryColID->setText(QString(atts->GetQueryColID().c_str()));
            break;
          case SeedMeAttributes::ID_queryKeyValue:
            queryKeyValue->setText(QString(atts->GetQueryKeyValue().c_str()));
            break;
          case SeedMeAttributes::ID_queryCollectionValues:
            queryCollectionValuesButtonGroup->blockSignals(true);
            if(queryCollectionValuesButtonGroup->button((int)atts->GetQueryCollectionValues()) != 0)
                queryCollectionValuesButtonGroup->button((int)atts->GetQueryCollectionValues())->setChecked(true);
            queryCollectionValuesButtonGroup->blockSignals(false);
            break;

          case SeedMeAttributes::ID_downloadCollectionID:
            downloadCollectionID->setText(IntToQString(atts->GetDownloadCollectionID()));
            break;
          case SeedMeAttributes::ID_downloadType:
            downloadTypeButtonGroup->blockSignals(true);
            if(downloadTypeButtonGroup->button((int)atts->GetDownloadType()) != 0)
                downloadTypeButtonGroup->button((int)atts->GetDownloadType())->setChecked(true);
            downloadTypeButtonGroup->blockSignals(false);
            break;
          case SeedMeAttributes::ID_downloadName:
            downloadName->setText(QString(atts->GetDownloadName().c_str()));
            break;
          case SeedMeAttributes::ID_quickSharing:
            quickSharingButtonGroup->blockSignals(true);
            if(quickSharingButtonGroup->button((int)atts->GetQuickSharing()) != 0)
                quickSharingButtonGroup->button((int)atts->GetQuickSharing())->setChecked(true);
            quickSharingButtonGroup->blockSignals(false);
            break;
          case SeedMeAttributes::ID_quickCollectionTitle:
            quickCollectionTitle->setText(QString(atts->GetQuickCollectionTitle().c_str()));
            break;
          case SeedMeAttributes::ID_quickCollectionEmails:
            quickCollectionEmails->setText(QString(atts->GetQuickCollectionEmails().c_str()));
            break;
          case SeedMeAttributes::ID_quickFrameRate:
            quickFrameRate->setText(IntToQString(atts->GetQuickFrameRate()));
            break;
          case SeedMeAttributes::ID_clearAllTabsOnClose:
            clearTabsOnClose->blockSignals(true);
            clearTabsOnClose->setChecked(atts->GetClearAllTabsOnClose());
            clearTabsOnClose->blockSignals(false);
            break;
        }
    }
}

// ****************************************************************************
// Method: QvisSeedMeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSeedMeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do collectionID
    if(which_widget == SeedMeAttributes::ID_collectionID || doAll)
    {
        int val;
        if(LineEditGetInt(collectionID, val))
            atts->SetCollectionID(val);
        else
        {
            ResettingError(tr("collection id"),
                IntToQString(atts->GetCollectionID()));
            atts->SetCollectionID(atts->GetCollectionID());
        }
    }

    // Do collectionTitle
    if(which_widget == SeedMeAttributes::ID_collectionTitle || doAll)
    {
        QString temp = collectionTitle->displayText();
        atts->SetCollectionTitle(temp.toStdString());

//        if(temp.isEmpty())
//            Error("Collection title field is required");
    }

    // Do collectionDescription
    if(which_widget == SeedMeAttributes::ID_collectionDescription || doAll)
    {
        QString temp = collectionDescription->displayText();
        atts->SetCollectionDescription(temp.toStdString());
    }

    // Do keyValue
    if(which_widget == SeedMeAttributes::ID_keyValue || doAll)
    {
        QString temp = keyValue->displayText();
        atts->SetKeyValue(temp.toStdString());
    }

    // Do collectionEmails
    if(which_widget == SeedMeAttributes::ID_collectionEmails || doAll)
    {
        QString temp = collectionEmails->displayText();
        atts->SetCollectionEmails(temp.toStdString());
    }

    // Do sequenceTitle
    if(which_widget == SeedMeAttributes::ID_sequenceTitle || doAll)
    {
        QString temp = sequenceTitle->displayText();
        atts->SetSequenceTitle(temp.toStdString());
    }

    // Do sequenceDescription
    if(which_widget == SeedMeAttributes::ID_sequenceDescription || doAll)
    {
        QString temp = sequenceDescription->displayText();
        atts->SetSequenceDescription(temp.toStdString());
    }

    // Do frameRate
    if(which_widget == SeedMeAttributes::ID_frameRate || doAll)
    {
        int val;
        if(LineEditGetInt(frameRate, val))
            atts->SetFrameRate(val);
        else
        {
            ResettingError(tr("frame rate"),
                IntToQString(atts->GetFrameRate()));
            atts->SetFrameRate(atts->GetFrameRate());
        }
    }

    // Do queryColID
    if(which_widget == SeedMeAttributes::ID_queryColID || doAll)
    {
        QString temp = queryColID->displayText();
        atts->SetQueryColID(temp.toStdString());
    }

    // Do queryKeyValue
    if(which_widget == SeedMeAttributes::ID_queryKeyValue || doAll)
    {
        QString temp = queryKeyValue->displayText();
        atts->SetQueryKeyValue(temp.toStdString());
    }

    // Do downloadCollectionID
    if(which_widget == SeedMeAttributes::ID_downloadCollectionID || doAll)
    {
        int val;
        if(LineEditGetInt(downloadCollectionID, val))
            atts->SetDownloadCollectionID(val);
        else
        {
            ResettingError(tr("Download collection id"),
                IntToQString(atts->GetDownloadCollectionID()));
            atts->SetDownloadCollectionID(atts->GetDownloadCollectionID());
        }
    }

    // Do downloadName
    if(which_widget == SeedMeAttributes::ID_downloadName || doAll)
    {
        QString temp = downloadName->displayText();
        atts->SetDownloadName(temp.toStdString());
    }
    // Do quickCollectionTitle
    if(which_widget == SeedMeAttributes::ID_quickCollectionTitle || doAll)
    {
        QString temp = quickCollectionTitle->displayText();
        atts->SetQuickCollectionTitle(temp.toStdString());
    }

    // Do quickCollectionEmails
    if(which_widget == SeedMeAttributes::ID_quickCollectionEmails || doAll)
    {
        QString temp = quickCollectionEmails->displayText();
        atts->SetQuickCollectionEmails(temp.toStdString());
    }

    // Do quickFrameRate
    if(which_widget == SeedMeAttributes::ID_quickFrameRate || doAll)
    {
        int val;
        if(LineEditGetInt(quickFrameRate, val))
            atts->SetQuickFrameRate(val);
        else
        {
            ResettingError(tr("Frame rate"),
                IntToQString(atts->GetQuickFrameRate()));
            atts->SetQuickFrameRate(atts->GetQuickFrameRate());
        }
    }
}

// ****************************************************************************
// Method: QvisSeedMeWindow::Apply
//
// Purpose: 
//   Called to apply changes in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSeedMeWindow::Apply(bool ignore)
{
    if(AutoUpdate() || ignore)
    {
        GetCurrentValues(-1);
        atts->Notify();

        QString str;
        str = "import seedme\n";
        str += "import visit, json, sys, shlex\n";
        str += "from os.path import expanduser\n";
        str += "obj = seedme.SeedMe()\n";
        str += "try: \n";
// str += "  with open(expanduser(\"~\")+'/.visit/seedme_apikey_path', 'r') as f:\n";
        str += "  with open(\""+QString(configFile)+"\", 'r') as f:\n";
        str += "    seedme_apikey = f.readline().rstrip()\n";
        str += "    obj.set_auth_via_file(seedme_apikey)\n";
        str += "except IOError as error:\n";
// str += "except:\n";
// str += "  visit.UpdateSeedMeStatus(\"\", \"Error processing request: %s\"%sys.exc_info()[1])\n";
        str += "  pass\n";

        str += "try:\n";

        switch(tabs->currentIndex())
        {
          case 0:
          {
            str += "  res = obj.create_collection(title=\""+QString::fromStdString(atts->GetQuickCollectionTitle())+"\",";
            str += "tags=\"visit\",";


            if(!uploadFiles.isEmpty())
            {
                str += "sequences=";
                str += "{\"filepath\":";
                if(uploadFiles.size() > 1)
                    str += "[";
                for (QStringList::iterator it = uploadFiles.begin(); it != uploadFiles.end(); ++it)
                {
                    str += "\""+*it+"\"";
                    if(it+1 != uploadFiles.end())
                        str += ",";
                }
                if(uploadFiles.size() > 1)
                    str += "]";
                str += ", \"title\":\""+QString::fromStdString(atts->GetQuickCollectionTitle())+"\"";

                str += ", \"encode\":True, \"fps\":\""+QString::number(atts->GetQuickFrameRate())+"\"";

                str += "},";
            }

            switch(atts->GetQuickSharing())
            {
              case SeedMeAttributes::SHARING_PRIVATE:
                str += "privacy=\"private\"";
                break;
              case SeedMeAttributes::SHARING_PUBLIC:
                str += "privacy=\"public\"";
                break;
              case SeedMeAttributes::SHARING_GROUP:
                str += "privacy=\"group\"";
                break;
            }

            if(atts->GetQuickSharing() != SeedMeAttributes::SHARING_PRIVATE && !atts->GetQuickCollectionEmails().empty())
            {
                str += ", sharing=\""+QString::fromStdString(atts->GetQuickCollectionEmails())+"\"";
            }

            str += ")\n";

            str += "  visit.UpdateSeedMeStatus(json.loads(res).get('collection_id'), res)\n";
            updateStatus("Submitted to SeedMe. Waiting for response");
            break;
          }
          case 1:
          {
            if(atts->GetCollectionMode() == SeedMeAttributes::COLLECTION_NEW)
                str += "  res = obj.create_collection(title=\""+QString::fromStdString(atts->GetCollectionTitle())+"\",";
            else
                str += "  res = obj.update_collection(collection_id="+QString().setNum(atts->GetCollectionID())+", title=\""+QString::fromStdString(atts->GetCollectionTitle())+"\",";

            str += "tags=\"visit\",";

            if(!atts->GetKeyValue().empty())
            {
                str += "keyvalues=dict([d.split(\":\") for d in shlex.split('"+QString::fromStdString(atts->GetKeyValue())+"')]), ";
            }

            if(!atts->GetUploadSequenceFile())
            {
                str += " files=[";

                for (QStringList::iterator it = uploadFiles.begin(); it != uploadFiles.end(); ++it)
                {
                    str += "{\"filepath\":\""+*it+"\"}";
                    if(it+1 != uploadFiles.end())
                    str += ",";
                }

                str += "],";
            }
            else
            {
                str += " sequences=";

                str += "{\"filepath\":";
                if(uploadFiles.size() > 1)
                    str += "[";
                for (QStringList::iterator it = uploadFiles.begin(); it != uploadFiles.end(); ++it)
                {
                    str += "\""+*it+"\"";
                    if(it+1 != uploadFiles.end())
                        str += ",";
                }
                if(uploadFiles.size() > 1)
                    str += "]";

                str += ", \"title\":\""+QString::fromStdString(atts->GetSequenceTitle())+"\", \"description\":\""+QString::fromStdString(atts->GetSequenceDescription())+"\"";

                if(atts->GetCreateVideo())
                {
                    str += ", \"encode\":True, \"fps\":\""+QString::number(atts->GetFrameRate())+"\"";
                }

                str += "},";
            }
            switch(atts->GetSharing())
            {
              case SeedMeAttributes::SHARING_PRIVATE:
                str += "privacy=\"private\"";
                break;
              case SeedMeAttributes::SHARING_PUBLIC:
                str += "privacy=\"public\"";
                break;
              case SeedMeAttributes::SHARING_GROUP:
                str += "privacy=\"group\"";
                break;
            }

            if(atts->GetSharing() != SeedMeAttributes::SHARING_PRIVATE && !atts->GetCollectionEmails().empty())
            {
                str += ", sharing=\""+QString::fromStdString(atts->GetCollectionEmails())+"\"";
            }

            if(!atts->GetCollectionDescription().empty())
                str += ", description=\""+QString::fromStdString(atts->GetCollectionDescription())+"\"";

            str += ")\n";

            str += "  visit.UpdateSeedMeStatus(json.loads(res).get('collection_id'), res)\n";
            updateStatus("Submitted to SeedMe");
            break;
          }
          case 2:
          {
            str += "  res = obj.query(";

            switch(atts->GetQueryAction())
            {
              case SeedMeAttributes::LIST_COL:
                break;
              case SeedMeAttributes::FIND_COL:
                str += "keyvalues=\""+QString::fromStdString(atts->GetQueryKeyValue())+"\"";
                break;
              case SeedMeAttributes::QUERY_COL:
                str += "cid=\""+QString::fromStdString(atts->GetQueryColID())+"\", ";
                switch(atts->GetQueryCollectionValues())
                {
                  case SeedMeAttributes::QUERY_ALL:
                    str += "content='all'";
                    break;
                  case SeedMeAttributes::QUERY_KEY_VALUE:
                    str += "content='kv'";
                    break;
                  case SeedMeAttributes::QUERY_TICKER:
                    str += "content='tic'";
                    break;
                  case SeedMeAttributes::QUERY_URL:
                    str += "content='url'";
                    break;
                }
                break;
            }

            str += ")\n";
            str += "  visit.UpdateSeedMeStatus('0', res)\n";
            updateStatus("Querying collection");
            break;
          }
          case 3:
          {
            QString saveToDir = QFileDialog::getExistingDirectory(this,
            tr("Save To..."), QDir::currentPath());
            if(saveToDir == NULL)
                return;

            str += "  res = obj.download('"+QString::number(atts->GetDownloadCollectionID())+"', path='"+saveToDir+"',";

            if(atts->GetDownloadType() == SeedMeAttributes::DOWNLOAD_ALL)
                str += "content='all'";
            else if(atts->GetDownloadType() == SeedMeAttributes::DOWNLOAD_VIDEO)
                str += "content='video'";
            else if(atts->GetDownloadType() == SeedMeAttributes::DOWNLOAD_NAME)
                str += "content='"+QString::fromStdString(atts->GetDownloadName())+"'";

            str += ")\n";
            str += "  if('error' in res): visit.UpdateSeedMeStatus('0', '%s'%json.loads(res)['error'])\n";
            str += "  else: visit.UpdateSeedMeStatus('0', 'Successfully downloaded files')\n";
            updateStatus("Downloading collection");
            break;
          }
        }
        str += "except:\n";
        str += "  visit.UpdateSeedMeStatus(\"\", \"Error processing request: %s\"%sys.exc_info()[1])\n";

        emit runCommand(str);
    }
}

void
QvisSeedMeWindow::quickDownload()
{
    GetCurrentValues(-1);
    atts->Notify();

    QString str;
    str = "import seedme\n";
    str += "import visit, json, sys\n";
    str += "from os.path import expanduser\n";
    str += "obj = seedme.SeedMe()\n";
    str += "try: \n";
    str += "  with open(\""+QString(configFile)+"\", 'r') as f:\n";
    str += "    seedme_apikey = f.readline().rstrip()\n";
    str += "    obj.set_auth_via_file(seedme_apikey)\n";
    str += "except IOError as error:\n";
    str += "  pass\n";

    str += "try:\n";

    QString saveToDir = QFileDialog::getExistingDirectory(this,
    tr("Save To..."), QDir::currentPath());
    if(saveToDir == NULL)
        return;

    str += "  res = obj.download('"+QString::number(atts->GetCollectionID())+"', path='"+saveToDir+"', ";

    switch(atts->GetQuickDownloadType())
    {
      case SeedMeAttributes::DOWNLOAD_Q_ALL:
        str += "content='video'";
        break;
      case SeedMeAttributes::DOWNLOAD_Q_BEST:
        str += "content='native'";
        break;
      case SeedMeAttributes::DOWNLOAD_Q_HIGHEST:
        str += "content='highest'";
        break;
      case SeedMeAttributes::DOWNLOAD_Q_HIGH:
        str += "content='high'";
        break;
      case SeedMeAttributes::DOWNLOAD_Q_MEDIUM:
        str += "content='medium'";
        break;
      case SeedMeAttributes::DOWNLOAD_Q_LOW:
        str += "content='low'";
        break;
      case SeedMeAttributes::DOWNLOAD_Q_LOWEST:
        str += "content='lowest'";
        break;
    }

    str += ")\n";
    str += "  if('error' in res): visit.UpdateSeedMeStatus('0', 'Video is not ready yet')\n";
    str += "  else: visit.UpdateSeedMeStatus('0', 'success')\n";

    str += "except:\n";
    str += "  visit.UpdateSeedMeStatus(\"\", \"Error processing request: %s\"%sys.exc_info()[1])\n";

    emit runCommand(str);
    updateStatus("Downloading collection");
}

void
QvisSeedMeWindow::updateStatus(QString str)
{
    if(!statusLabel->toPlainText().isEmpty())
        statusLabel->setText(statusLabel->toPlainText()+"\n=======================================\n");
    statusLabel->setText(statusLabel->toPlainText()+str);

    QScrollBar *sb = statusLabel->verticalScrollBar();
    sb->setValue(sb->maximum());

}

//
// Qt Slot functions
//


// ****************************************************************************
// Method: QvisSeedMeWindow::apply
//
// Purpose: 
//   Qt slot function called when apply button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSeedMeWindow::apply()
{
    Apply(true);
}

void
QvisSeedMeWindow::collectionModeChanged(int val)
{
    if(val != atts->GetCollectionMode())
    {
        atts->SetCollectionMode(SeedMeAttributes::CollectionMode(val));
        collectionID->setDisabled(atts->GetCollectionMode() == SeedMeAttributes::COLLECTION_NEW);
        collectionIDLabel->setDisabled(atts->GetCollectionMode() == SeedMeAttributes::COLLECTION_NEW);
        if(val == SeedMeAttributes::COLLECTION_NEW)
            collectionTitle->setPlaceholderText("Required");
        else
            collectionTitle->setPlaceholderText("Enter revised title");

        SetUpdate(false);
        Apply();
    }
}

void
QvisSeedMeWindow::collectionIDProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_collectionID);
    Apply();
}

void
QvisSeedMeWindow::sharingChanged(int val)
{
    if(val != atts->GetSharing())
    {
        atts->SetSharing(SeedMeAttributes::Sharing(val));

        collectionEmails->setDisabled(atts->GetSharing() == SeedMeAttributes::SHARING_PRIVATE);
        collectionEmailsLabel->setDisabled(atts->GetSharing() == SeedMeAttributes::SHARING_PRIVATE);

        SetUpdate(false);
        Apply();
    }
}

void
QvisSeedMeWindow::collectionTitleProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_collectionTitle);
    Apply();
}

void
QvisSeedMeWindow::collectionDescriptionProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_collectionDescription);
    Apply();
}

void
QvisSeedMeWindow::collectionEmailsProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_collectionEmails);
    Apply();
}

void
QvisSeedMeWindow::overwriteFilesChanged(bool val)
{
    atts->SetOverwriteFiles(val);
    SetUpdate(false);
    Apply();
}

void
QvisSeedMeWindow::keyValueProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_keyValue);
    Apply();
}

void
QvisSeedMeWindow::uploadSequenceFileChanged(bool val)
{
    atts->SetUploadSequenceFile(val);

    this->sequenceTitle->setDisabled(!val);
    this->sequenceDescription->setDisabled(!val);
    this->sequenceTitleLabel->setDisabled(!val);
    this->sequenceDescriptionLabel->setDisabled(!val);

    this->createVideo->setDisabled(!val);
    this->frameRate->setDisabled(!this->createVideo->isChecked() || !val);
    this->frameRateLabel->setDisabled(!this->createVideo->isChecked() || !val);

    SetUpdate(false);
    Apply();
}

void
QvisSeedMeWindow::sequenceTitleProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_sequenceTitle);
    Apply();
}

void
QvisSeedMeWindow::sequenceDescriptionProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_sequenceDescription);
    Apply();
}

void
QvisSeedMeWindow::createVideoChanged(bool val)
{
    atts->SetCreateVideo(val);
    this->frameRate->setDisabled(!val);
    this->frameRateLabel->setDisabled(!val);
    SetUpdate(false);
    Apply();
}

void
QvisSeedMeWindow::frameRateProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_frameRate);
    Apply();
}

void
QvisSeedMeWindow::queryActionChanged(int val)
{
    if(val != atts->GetQueryAction())
    {
        atts->SetQueryAction(SeedMeAttributes::QueryAction(val));
        this->queryColID->setDisabled(atts->GetQueryAction() != SeedMeAttributes::QUERY_COL);
        this->queryColIDLabel->setDisabled(atts->GetQueryAction() != SeedMeAttributes::QUERY_COL);
        this->queryCollectionValues->setDisabled(atts->GetQueryAction() != SeedMeAttributes::QUERY_COL);
        this->queryCollectionValuesLabel->setDisabled(atts->GetQueryAction() != SeedMeAttributes::QUERY_COL);
        this->queryKeyValue->setDisabled(atts->GetQueryAction() != SeedMeAttributes::FIND_COL);
        this->queryKeyValueLabel->setDisabled(atts->GetQueryAction() != SeedMeAttributes::FIND_COL);
        Apply();
    }
}

void
QvisSeedMeWindow::queryColIDProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_queryColID);
    Apply();
}

void
QvisSeedMeWindow::queryKeyValueProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_queryKeyValue);
    Apply();
}

void
QvisSeedMeWindow::queryCollectionValuesChanged(int val)
{
    if(val != atts->GetQueryCollectionValues())
    {
        atts->SetQueryCollectionValues(SeedMeAttributes::QueryCollectionValues(val));
        SetUpdate(false);
        Apply();
    }
}

void
QvisSeedMeWindow::downloadCollectionIDProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_downloadCollectionID);
    Apply();
}

void
QvisSeedMeWindow::downloadTypeChanged(int val)
{
    if(val != atts->GetDownloadType())
    {
        atts->SetDownloadType(SeedMeAttributes::Download(val));

        downloadName->setDisabled(atts->GetDownloadType() != SeedMeAttributes::DOWNLOAD_NAME);

        SetUpdate(false);
        Apply();
    }
}

void
QvisSeedMeWindow::downloadNameProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_downloadName);
    Apply();
}

void
QvisSeedMeWindow::quickSharingChanged(int val)
{
    if(val != atts->GetQuickSharing())
    {
        atts->SetQuickSharing(SeedMeAttributes::Sharing(val));
        SetUpdate(false);
        Apply();
    }
}

void
QvisSeedMeWindow::quickCollectionTitleProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_quickCollectionTitle);
    Apply();
}

void
QvisSeedMeWindow::quickCollectionEmailsProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_quickCollectionEmails);
    Apply();
}

void
QvisSeedMeWindow::quickFrameRateProcessText()
{
    GetCurrentValues(SeedMeAttributes::ID_quickFrameRate);
    Apply();
}

void
QvisSeedMeWindow::quickDownloadTypeChanged(int val)
{
    if(val != atts->GetQuickDownloadType())
    {
        atts->SetQuickDownloadType(SeedMeAttributes::DownloadQuality(val));
        SetUpdate(false);
        Apply();
    }
}

void
QvisSeedMeWindow::clearTabsOnCloseChanged(bool val)
{
    atts->SetClearAllTabsOnClose(val);
    atts->Notify();
}
