// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: paraDIS_tecplotPluginInfo.C
// ****************************************************************************

#include <paraDIS_tecplotPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(paraDIS_tecplot,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(paraDIS_tecplot,General)

// ****************************************************************************
//  Method: paraDIS_tecplotGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
paraDIS_tecplotGeneralPluginInfo::GetName() const
{
    return "paraDIS_tecplot";
}

// ****************************************************************************
//  Method: paraDIS_tecplotGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
paraDIS_tecplotGeneralPluginInfo::GetVersion() const
{
    return "1.0a1";
}

// ****************************************************************************
//  Method: paraDIS_tecplotGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
paraDIS_tecplotGeneralPluginInfo::GetID() const
{
    return "paraDIS_tecplot_1.0a1";
}
// ****************************************************************************
//  Method: paraDIS_tecplotGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
paraDIS_tecplotGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: paraDIS_tecplotGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
paraDIS_tecplotGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  paraDIS_tecplotGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a paraDIS_tecplot database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
paraDIS_tecplotGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.fld");
    defaultPatterns.push_back("*.field");
    defaultPatterns.push_back("*.cyl");
    defaultPatterns.push_back("*.cylinder");
    defaultPatterns.push_back("*.dat");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  paraDIS_tecplotGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a paraDIS_tecplot database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
paraDIS_tecplotGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  paraDIS_tecplotGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the paraDIS_tecplot plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
paraDIS_tecplotGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
