// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.
// ************************************************************************* //
//                            avtlataFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_lata_FILE_FORMAT_H
#define AVT_lata_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>
#include "LataFilter.h"

// ****************************************************************************
//  Class: avtlataFileFormat
//
//  Purpose:
//      Reads in lata files as a plugin to VisIt.
//
//  Programmer: fauchet -- generated by xml2avt
//
// ****************************************************************************

class avtlataFileFormat : public avtMTMDFileFormat
{
  public:
    avtlataFileFormat(const char *);
    virtual ~avtlataFileFormat();

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, const char *type,
    //                                     int timestep, int domain,void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    // virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "lata"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);
    virtual void GetTimes(std::vector<double>& times);
  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    void register_fieldname(const char *visit_name, const Field_UName &, int component);
    void register_meshname(const char *visit_name, const char *latafilter_name);
    void get_field_info_from_visitname(const char *varname, Field_UName &, int & component) const;

    LataDB      lata_db_; // Source database
    LataFilter  filter_; // Data processor and cache
    Noms field_username_;
    Field_UNames field_uname_;

    Noms mesh_username_;
    Noms mesh_latafilter_name_;

    // For each name, which component is it in the source field:
    LataVector<int> field_component_;
};


#endif
