// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ZipWrapperPluginInfo.h>
#include <avtZipWrapperFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtZipWrapperOptions.h>

// ****************************************************************************
//  Method:  ZipWrapperCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ZipWrapper database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
ZipWrapperCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: ZipWrapperCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a ZipWrapper database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ZipWrapper database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//    Brad Whitlock, Tue Jun 24 16:41:08 PDT 2008
//    Pass this into the file format interface so it can use the plugin manager.
//
// ****************************************************************************
avtDatabase *
ZipWrapperCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtZipWrapperFileFormatInterface(list, nList, nBlock,
                                                    readOptions, this));
}


// ****************************************************************************
//  Method: ZipWrapperCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
ZipWrapperCommonPluginInfo::GetReadOptions() const
{
    return GetZipWrapperReadOptions();
}

// ****************************************************************************
//  Method: ZipWrapperCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
ZipWrapperCommonPluginInfo::GetWriteOptions() const
{
    return GetZipWrapperWriteOptions();
}

