// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers. See the top-level LICENSE file for dates and other
// details. No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtXolotlFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_Xolotl_FILE_FORMAT_H
#define AVT_Xolotl_FILE_FORMAT_H

#include <avtMTSDFileFormat.h>

#include <vector>
#include <hdf5.h>

class DBOptionsAttributes;


// ****************************************************************************
//  Class: avtXolotlFileFormat
//
//  Purpose:
//      Reads in Xolotl files as a plugin to VisIt.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Tue Mar 22 15:09:52 PST 2016
//
// ****************************************************************************

class avtXolotlFileFormat : public avtMTSDFileFormat
{
  public:
                       avtXolotlFileFormat(const char *, DBOptionsAttributes *);
    virtual           ~avtXolotlFileFormat();

    void               Initialize();

    virtual void        GetCycles(std::vector<int> &);
    virtual void        GetTimes(std::vector<double> &);

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "Xolotl"; };
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    hid_t                  fileId;
    int                    nTimeStates;

    std::string            filename;

    int                    dimension;
    int                    nx, ny, nz;
    int                    hx, hy, hz;
    int                    varMaxes[5];

    std::vector<int>       isurface;
    std::vector<int>       cycleNumbers;
    std::vector<double>    times;
    std::vector<double>    network;
    std::vector<double>    oneDGrid;
    std::vector< std::vector<double> >    concentrations;
    hsize_t                networkSize;
    hsize_t                networkParams;
    hid_t                  concentrationsGroup;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
    void                   PopulateHeaderGroupMetaData();
    void                   PopulateConcentrationGroupMetaData();
    void                   GetPositionsOfVariableFromCompositionTable(int *variableIndexes, const char *vn);
    static int             GroupInfo(hid_t loc_id, const char *name, const H5L_info_t *linfo, void *opdata);
};


#endif
