// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <XolotlPluginInfo.h>
#include <avtXolotlFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtXolotlOptions.h>

// ****************************************************************************
//  Method:  XolotlCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Xolotl database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
XolotlCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method: XolotlCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a Xolotl database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Xolotl database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
XolotlCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    int nTimestepGroups = nList / nBlock;
    avtMTSDFileFormat ***ffl = new avtMTSDFileFormat**[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtMTSDFileFormat*[nBlock];
        for (int j = 0; j < nBlock; j++)
        {
            ffl[i][j] = new avtXolotlFileFormat(list[i*nBlock + j], readOptions);
        }
    }
    avtMTSDFileFormatInterface *inter
           = new avtMTSDFileFormatInterface(ffl, nTimestepGroups, nBlock);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: XolotlCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
XolotlCommonPluginInfo::GetReadOptions() const
{
    return GetXolotlReadOptions();
}

// ****************************************************************************
//  Method: XolotlCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
XolotlCommonPluginInfo::GetWriteOptions() const
{
    return GetXolotlWriteOptions();
}

