// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtXGCFileFormat.h                             //
// ************************************************************************* //

#ifndef AVT_XGC_FILE_FORMAT_H
#define AVT_XGC_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>

#include <hdf5.h>

#include <visit-hdf5.h>

#include <string>

// ****************************************************************************
//  Class: avtXGCFileFormat
//
//  Purpose:
//      Reads in XGC files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Jun 7 11:27:14 PDT 2016
//
// ****************************************************************************

class avtXGCFileFormat : public avtSTSDFileFormat
{
  public:
                       avtXGCFileFormat(const char *filename);
    virtual           ~avtXGCFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, const char *type,
    //                                  void *args, DestructorFunction &);
    //

    //
    // These are used to declare what the current time and cycle are for the
    // file.  These should only be defined if the file format knows what the
    // time and/or cycle is.
    //
    // virtual int       GetCycle(void);
    // virtual double    GetTime(void);
    //

    virtual const char    *GetType(void)   { return "XGC"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);

  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    void Initialize();

    bool initialized;
    int numNodes, numPhi, numTri;
};

#endif
