// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                       avtWavefrontOBJWriter.C                             //
// ************************************************************************* //

#include <avtWavefrontOBJWriter.h>

#include <vector>

#include <vtkAlgorithm.h>
#include <vtkAppendPolyData.h>
#include <vtkDataSet.h>
#include <vtkGeometryFilter.h>
#include <vtkDataSetWriter.h>
#include <vtkPolyDataReader.h>
#include <vtkPolyDataWriter.h>
#include <vtkCharArray.h>
#include <vtkPolyData.h>
#include <vtkTriangleFilter.h>
#include <avtDatabaseMetaData.h>
#include <DBOptionsAttributes.h>
#include <vtkOBJWriter.h>

#include <avtDatabaseMetaData.h>
#include <DebugStream.h>
#include <avtParallelContext.h>

using     std::string;
using     std::vector;


// ****************************************************************************
//  Method: avtWavefrontOBJWriter constructor
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

avtWavefrontOBJWriter::avtWavefrontOBJWriter(void)
{
}

// ****************************************************************************
//  Method: avtWavefrontOBJWriter::OpenFile
//
//  Purpose:
//      Does no actual work.  Just records the stem name for the files.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

void
avtWavefrontOBJWriter::OpenFile(const string &stemname, int numblocks)
{
    stem = stemname;
}


// ****************************************************************************
//  Method: avtWavefrontOBJWriter::WriteHeaders
//
//  Purpose:
//      Writes out a VisIt file to tie the WavefrontOBJ files together.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

void
avtWavefrontOBJWriter::WriteHeaders(const avtDatabaseMetaData *md,
                                    const vector<string> &scalars,
                                    const vector<string> &vectors,
                                    const vector<string> &materials)
{
    // WRITE OUT HEADER INFO
}


// ****************************************************************************
//  Method: avtWavefrontOBJWriter::WriteChunk
//
//  Purpose:
//      This writes out one chunk of an avtDataset.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
//  Modifications:
//    Brad Whitlock, Tue Sep  8 17:04:07 PDT 2015
//    Rely on base class for geometry consolidation. This method will only
//    be called on group leaders.
//
// ****************************************************************************

void
avtWavefrontOBJWriter::WriteChunk(vtkDataSet *ds, int chunk)
{
    std::string filename;
    if(writeContext.GroupSize() > 1)
    {
        char ext[20];
        snprintf(ext, 20, ".%d.obj", writeContext.GroupRank());
        filename = stem + ext;
    }
    else
        filename = stem + ".obj";

    vtkOBJWriter *writer = vtkOBJWriter::New();  
    writer->SetFileName(filename.c_str());
    writer->SetInputData(ds);
    writer->Update();
    writer->Delete();
}

// ****************************************************************************
//  Method: avtWavefrontOBJWriter::CloseFile
//
//  Purpose:
//      Closes the file.  This does nothing in this case.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

void
avtWavefrontOBJWriter::CloseFile(void)
{
}

// ****************************************************************************
// Method: avtWavefrontOBJWriter::CreateTrianglePolyData
//
// Purpose:
//   Tell VisIt's export that we'll want triangles.
//
// Returns:    True
//
// Programmer: Brad Whitlock
// Creation:   Tue Sep  8 17:00:23 PDT 2015
//
// Modifications:
//
// ****************************************************************************

bool
avtWavefrontOBJWriter::CreateTrianglePolyData() const
{
    return true;
}

// ****************************************************************************
//  Method: avtTecplotWriter::GetCombineMode
//
//  Purpose:
//     Provides a hint to the export mechanism to tell it how to combine data.
//
//  Note: We combine geometry because WavefrontOBJ tools will want 1 file.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Sep  8 15:36:45 PDT 2015
//
// ****************************************************************************

avtDatabaseWriter::CombineMode
avtWavefrontOBJWriter::GetCombineMode(const std::string &) const
{
    return CombineAll;
}
