// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                         avtWPPImageFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_WPPImage_FILE_FORMAT_H
#define AVT_WPPImage_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>
#include <string>

// ****************************************************************************
//  Class: avtWPPImageFileFormat
//
//  Purpose:
//      Reads in WPPImage files as a plugin to VisIt.
//
//  Programmer: bjorn -- generated by xml2avt
//  Creation:   Fri Jan 13 16:02:12 PST 2012
//
// ****************************************************************************

class avtWPPImageFileFormat : public avtSTMDFileFormat
{
  public:
                       avtWPPImageFileFormat(const char *);
    virtual           ~avtWPPImageFileFormat() {;};

    virtual const char    *GetType(void)   { return "WPPImage"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    void Initialize();

    // DATA MEMBERS
    std::string m_filename;
    bool m_initialized;
    bool m_CartGrid;
    int m_prec;
    int m_nblocks;
    std::vector<double> m_gridsize;
    std::string m_mode;
    std::vector<double> m_xmin;
    std::vector<double> m_ymin;
    std::vector<double> m_zmin;
    std::vector<int> m_ni;
    std::vector<int> m_nj;
    std::vector<int> m_nk;
    std::vector<off_t> m_offset;
};


#endif
