// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                              avtVTKOptions.C                              //
// ************************************************************************* //

#include <avtVTKOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;

// ****************************************************************************
//  Function: GetVTKReadOptions
//
//  Purpose:
//      Creates the options for VTK readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue May 24 16:43:26 PST 2005
//
// ****************************************************************************

DBOptionsAttributes *
GetVTKReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}


// ****************************************************************************
//  Function: GetVTKWriteOptions
//
//  Purpose:
//      Creates the options for VTK writers.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue May 24 16:43:26 PST 2005
//
//  Modifications:
//    Kathleen Biagas, Thu Dec 18 14:51:46 PST 2014
//    Added "XML Format".
//
//    Kathleen Biagas, Fri Feb 17 15:50:34 PST 2017
//    New options so as to be more explicit.
//
//    Mark C. Miller, Tue Apr  9 18:49:37 PDT 2019
//    Add tetrahedralize option and help string.
// ****************************************************************************

DBOptionsAttributes *
GetVTKWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    vector<string> fileFormat;
    fileFormat.push_back("Legacy Ascii");
    fileFormat.push_back("Legacy Binary");
    fileFormat.push_back("XML Ascii");
    fileFormat.push_back("XML Binary");
    rv->SetEnum("FileFormat", 0);
    rv->SetEnumStrings("FileFormat", fileFormat);
    rv->SetBool("Tetrahedralize", false);

    rv->SetObsolete("Binary format");
    rv->SetObsolete("XML format");

    char helpStr[256];
    snprintf(helpStr, sizeof(helpStr),
        "<p><b>Tetrahedralize</b>:"
        "<ul>"
        "<li>Works only for UNstructured grids.</li>"
        "<li>In 2D, converts all polygons to triangles.</li>"
        "<li>In 3D, converts all polyhedra to tets.</li>"
        "</ul>");
    rv->SetHelp(helpStr);

    return rv;
}
