// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VASPPluginInfo.C
// ****************************************************************************

#include <VASPPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(VASP,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(VASP,General)

// ****************************************************************************
//  Method: VASPGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VASPGeneralPluginInfo::GetName() const
{
    return "VASP";
}

// ****************************************************************************
//  Method: VASPGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VASPGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: VASPGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VASPGeneralPluginInfo::GetID() const
{
    return "VASP_1.0";
}
// ****************************************************************************
//  Method: VASPGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VASPGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: VASPGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VASPGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  VASPGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a VASP database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
VASPGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("OUT*");
    defaultPatterns.push_back("POS*");
    defaultPatterns.push_back("CHG*");
    defaultPatterns.push_back("CONT*");
    defaultPatterns.push_back("XDAT*");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  VASPGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a VASP database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
VASPGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  VASPGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the VASP plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
VASPGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
