// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <VASPPluginInfo.h>
#include <avtVASPFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  VASPCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a VASP database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
VASPCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method: VASPCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a VASP database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A VASP database from list.
//
//  Programmer: js9 -- generated by xml2info
//  Creation:   Mon Aug 7 16:48:43 PST 2006
//
// ****************************************************************************

avtDatabase *
VASPCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtDatabase *db = 0;

    //
    // Create a file format interface.
    //
    avtFileFormatInterface *ffi = VASP_CreateFileFormatInterface(list,
                                                                 nList,
                                                                 nBlock);

    //
    // If we created a file format interface, try creating a database.
    //
    if(ffi)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(ffi);
        }
        CATCH(VisItException)
        {
            delete ffi;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;
}

