// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtUintahFileFormat.h                          //
// ************************************************************************* //

#ifndef AVT_UINTAH_FILE_FORMAT_H
#define AVT_UINTAH_FILE_FORMAT_H

#include <visit-config.h>

#if (VISIT_APP_VERSION_CHECK(2, 5, 1) <= UINTAH_VERSION_HEX )
#include <VisIt/interfaces/datatypes.h>
#elif (VISIT_APP_VERSION_CHECK(2, 5, 0) <= UINTAH_VERSION_HEX )
#include <VisIt/uda2vis/udaData.h>
#else
#include <StandAlone/tools/uda2vis/udaData.h>
#endif

#include <avtMTMDFileFormat.h>

#include <map>
#include <set>
#include <string>
#include <vector>

// ****************************************************************************
//  Class: avtUintahFileFormat
//
//  Purpose:
//      Reads in Uintah files as a plugin to VisIt.
//
//  Programmer: sshankar -- generated by xml2avt
//  Creation:   Tue May 13 19:02:26 PST 2008
//
// ****************************************************************************

// the DataArchive and GridP types are considered opaque from this library, we dlsym()
// functions from uintah libs to allocate, free, and perform operations on them.
class DataArchive;
class GridP;
class Patch;
class DBOptionsAttributes;

class TimeStepInfo;

class avtUintahFileFormat : public avtMTMDFileFormat
{
public:
  avtUintahFileFormat( const char * filename, DBOptionsAttributes* attrs);
  virtual           ~avtUintahFileFormat();

  virtual double        GetTime( int timestep );
  virtual int           GetNTimesteps( void );

  virtual const char    *GetType( void )   { return "Uintah"; };
  virtual void          ActivateTimestep( int timestep ); 

  virtual vtkDataSet    *GetMesh( int timestate, int domain, const char * meshname );
  virtual vtkDataArray  *GetVar(  int timestate, int domain, const char * varname );
  virtual vtkDataArray  *GetVectorVar( int timestate, int domain, const char * varname );


protected:

  virtual void     PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
  void             ReadMetaData(avtDatabaseMetaData *, int);

  virtual void     *GetAuxiliaryData(const char *var, int,
                                     const char *type, void *args,
                                     DestructorFunction &);

  void             GetLevelAndLocalPatchNumber(int, int&, int&);
  int              GetGlobalDomainNumber(int, int);
  
  void             GetDomainBoundariesAndNesting(int, const std::string&);
        
  virtual bool     HasInvariantMetaData(void) const { return !dataVariesOverTime; };
  virtual bool     HasInvariantSIL(void) const { return !dataVariesOverTime; };

  void             AddExpressionsToMetadata(avtDatabaseMetaData *md);
  void             CheckNaNs(double *data, const int num,
                             const char* varname,
                             const int level, const int patch);

  void             addRectilinearMesh( avtDatabaseMetaData *md,
                                       std::set<std::string> &meshes_added,
                                       std::string meshName,
                                       TimeStepInfo* stepInfo );
  
  void             addParticleMesh( avtDatabaseMetaData *md,
                                    std::set<std::string> &meshes_added,
                                    std::string meshName,
                                    TimeStepInfo* stepInfo );
  
  void             addMeshNodeRankSIL( avtDatabaseMetaData *md,
                                       std::string mesh );

  void             addMeshVariable( avtDatabaseMetaData *md,
                                    std::set<std::string> &mesh_vars_added,
                                    std::string varName, std::string varType,
                                    std::string meshName, avtCentering cent );
  
  // Data members
  int  loadExtraGeometry  {0};
  bool dataVariesOverTime {true};
  bool forceMeshReload    {true};

  int currTimeStep        {0};

  // VisIt meshes (see https://visitbugs.ornl.gov/issues/52)
  std::map<std::string, void_ref_ptr> mesh_domains;
  std::map<std::string, void_ref_ptr> mesh_boundaries;

  // Data that is not dependent on time
  DataArchive *archive {nullptr};

  unsigned int nProcs {0};
  std::vector<double> cycleTimes;

  // Data that is dependent on time
  GridP *grid            {nullptr};
  TimeStepInfo *stepInfo {nullptr};
        
  // Symbols in the archive interface library
  void * libHandle {nullptr};

  DataArchive*        (*openDataArchive)(const std::string&) {nullptr};
  void                (*closeDataArchive)(DataArchive*);

  GridP*              (*getGrid)(DataArchive*, int) {nullptr};
  void                (*releaseGrid)(GridP*) {nullptr};

  unsigned int        (*queryProcessors)(DataArchive*) {nullptr};
  std::vector<double> (*getCycleTimes)(DataArchive*) {nullptr};
  TimeStepInfo*       (*getTimeStepInfo)(DataArchive*, GridP*,
                                         int, int) {nullptr};

  bool                (*variableExists)(DataArchive*, std::string) {nullptr};

  GridDataRaw*        (*getGridData)(DataArchive*, GridP*, int, int,
                                     std::string, int, int,
                                     int[3], int[3], int) {nullptr};

  unsigned int        (*getNumberParticles)(DataArchive*, GridP*, int, int,
                                            int, int) {nullptr};

  ParticleDataRaw*    (*getParticleData)(DataArchive*, GridP*, int, int,
                                         std::string, int, int) {nullptr};

  std::string         (*getParticlePositionName)(DataArchive*) {nullptr};
};
#endif
