// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                       avtStreamGhostTestFileFormat.h                      //
// ************************************************************************* //

#ifndef AVT_StreamGhostTest_FILE_FORMAT_H
#define AVT_StreamGhostTest_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>


// ****************************************************************************
//  Class: avtStreamGhostTestFileFormat
//
//  Purpose:
//      Reads in StreamGhostTest files as a plugin to VisIt.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Feb 10 08:39:02 PDT 2008
//
// ****************************************************************************

class avtStreamGhostTestFileFormat : public avtSTMDFileFormat
{
  public:
                       avtStreamGhostTestFileFormat(const char *);
    virtual           ~avtStreamGhostTestFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int domain,
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the cycle number, overload this function.
    // Otherwise, VisIt will make up a reasonable one for you.
    //
    // virtual int         GetCycle(void);
    //

    virtual const char    *GetType(void)   { return "StreamGhostTest"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
};


#endif
