// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtSXRISFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_SXRIS_FILE_FORMAT_H
#define AVT_SXRIS_FILE_FORMAT_H

#include <hdf5.h>
#include <visit-hdf5.h>
#include <avtMTSDFileFormat.h>
#include <vector>

// ****************************************************************************
//  Class: avtSXRISFileFormat
//
//  Purpose:
//      Reads in SXRIS files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Wed Oct 3 10:13:30 PDT 2012
//
// ****************************************************************************

class avtSXRISFileFormat : public avtMTSDFileFormat
{
  public:
                       avtSXRISFileFormat(const char *);
    virtual           ~avtSXRISFileFormat();

    virtual int            GetNTimesteps(void);
    virtual void           GetTimes(std::vector<double> &);
    virtual void           GetCycles(std::vector<int> &);

    virtual const char    *GetType(void)   { return "SXRIS"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    hid_t fileId;
    int dimensions[3];
    bool opened;
    char *filename;
    std::vector<double> times, YSteps, ZSteps;
    std::string timeLabel, YLabel, ZLabel;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
    void                   LoadFile();
};


#endif
