// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtSTLWriter.h                                //
// ************************************************************************* //

#ifndef AVT_STL_WRITER_H
#define AVT_STL_WRITER_H
#include <avtDatabaseWriter.h>

#include <string>
#include <vector>

class DBOptionsAttributes;
class vtkPolyData;

// ****************************************************************************
//  Class: avtSTLWriter
//
//  Purpose:
//      A module that writes out STL files.
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Jan 27 14:13:01 PST 2012
//
//  Modifications:
//    Brad Whitlock, Tue Sep  8 17:03:17 PDT 2015
//    Rely on base class for geometry aggregation.
//
// ****************************************************************************

class
avtSTLWriter : public avtDatabaseWriter
{
  public:
                   avtSTLWriter(DBOptionsAttributes *);
    virtual       ~avtSTLWriter() {}

  protected:
    std::string    stem;

    virtual void   OpenFile(const std::string &, int nb);
    virtual void   WriteHeaders(const avtDatabaseMetaData *,
                                const std::vector<std::string> &, 
                                const std::vector<std::string> &,
                                const std::vector<std::string> &);
    virtual void   WriteChunk(vtkDataSet *, int);
    virtual void   CloseFile(void);

    virtual bool          CreateTrianglePolyData() const;
    virtual CombineMode   GetCombineMode(const std::string &plotName) const;

  private:
    bool                       doBinary;
};


#endif
