// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SAMRAIPluginInfo.C
// ****************************************************************************

#include <SAMRAIPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(SAMRAI,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(SAMRAI,General)

// ****************************************************************************
//  Method: SAMRAIGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SAMRAIGeneralPluginInfo::GetName() const
{
    return "SAMRAI";
}

// ****************************************************************************
//  Method: SAMRAIGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SAMRAIGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: SAMRAIGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SAMRAIGeneralPluginInfo::GetID() const
{
    return "SAMRAI_1.0";
}
// ****************************************************************************
//  Method: SAMRAIGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SAMRAIGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: SAMRAIGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SAMRAIGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  SAMRAIGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a SAMRAI database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
SAMRAIGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.samrai");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  SAMRAIGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a SAMRAI database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
SAMRAIGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  SAMRAIGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the SAMRAI plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
SAMRAIGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
