// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtRAGEFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_RAGE_FILE_FORMAT_H
#define AVT_RAGE_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>
#include <hdfi.h>
#include <map>
#include <vector>
#include <string>
#include <algorithm>

// ****************************************************************************
//  Class: avtRAGEFileFormat
//
//  Purpose:
//      Reads in RAGE files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Mon Oct 20 14:11:41 PST 2014
//
// ****************************************************************************

class avtRAGEFileFormat : public avtSTSDFileFormat
{
  public:
    avtRAGEFileFormat(const char *filename);
    virtual ~avtRAGEFileFormat() {}

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, const char *type,
    //                                  void *args, DestructorFunction &);
    //

    virtual int       GetCycle() {Initialize(); return cycle;}
    virtual double    GetTime() {Initialize(); return time;}

    virtual const char    *GetType() {return "RAGE";}
    virtual void           FreeUpResources();

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);

  protected:

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    void                   Initialize();

    bool initialized;
    double time;
    int cycle;
    
    struct meshInfo
    {
        std::vector<double> dimMin, dimMax;
        std::vector<int> dimNum;
    };
    std::map<std::string, meshInfo> meshes;

    struct varInfo
    {
        int32 dataType;
        std::string meshNm;
    };
    std::map<std::string, varInfo> vars;
};


#endif
