// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                        avtPlainTextFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_PlainText_FILE_FORMAT_H
#define AVT_PlainText_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>

class DBOptionsAttributes;

// ****************************************************************************
//  Class: avtPlainTextFileFormat
//
//  Purpose:
//      Reads in PlainText files as a plugin to VisIt.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Thu Jan 24 10:45:23 PDT 2008
//
//  Modifications:
//
//    Mark C. Miller, Wed Oct 29 12:32:11 PDT 2008
//    Made it possible for curves to have any column as the abscissa
// ****************************************************************************

class avtPlainTextFileFormat : public avtSTSDFileFormat
{
  public:
                       avtPlainTextFileFormat(const char *filename, DBOptionsAttributes *);
    virtual           ~avtPlainTextFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, const char *type,
    //                                  void *args, DestructorFunction &);
    //

    //
    // These are used to declare what the current time and cycle are for the
    // file.  These should only be defined if the file format knows what the
    // time and/or cycle is.
    //
    // virtual int       GetCycle(void);
    // virtual double    GetTime(void);
    //

    virtual const char    *GetType(void)   { return "PlainText"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);

  protected:
    virtual void           ReadFile();
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);


    enum Format
    {
        Grid,
        Columns
    };
    bool        firstRowIsHeader;
    Format      format;
    int         skipLines;
    int         xcol;
    int         ycol;
    int         zcol;
    int         acol;

    int nrows;
    int ncolumns;
    std::string filename;
    bool fileRead;
    std::vector< std::vector<float> > data;
    std::vector<std::string> variableNames;
    
};


#endif
