// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtPLYOptions.C                              //
// ************************************************************************* //

#include <avtPLYOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetPLYReadOptions
//
//  Purpose:
//      Creates the options for PLY readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 09:43:05 PDT 2013
//
// ****************************************************************************

DBOptionsAttributes *
GetPLYReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
    
/* EXAMPLE OF OPTIONS

    rv->SetBool("Big Endian", false);
    rv->SetEnum("Dimension", 1);
    vector<string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
}


// ****************************************************************************
//  Function: GetPLYWriteOptions
//
//  Purpose:
//      Creates the options for PLY writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 09:43:05 PDT 2013
//
//  Modifications:
//
//   Dave Pugmire, Fri Apr 26 12:33:39 EDT 2013
//   Add color table options.
//
// ****************************************************************************

DBOptionsAttributes *
GetPLYWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Binary format", true);
    rv->SetBool("Output colors", false);
    rv->SetString("Color table", "hot");
    rv->SetDouble("Color table min", 0.0);
    rv->SetDouble("Color table max", 1.0);
    return rv;
}
