// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OpenPMDPluginInfo.C
// ****************************************************************************

#include <OpenPMDPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(OpenPMD,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(OpenPMD,General)

// ****************************************************************************
//  Method: OpenPMDGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenPMDGeneralPluginInfo::GetName() const
{
    return "OpenPMD";
}

// ****************************************************************************
//  Method: OpenPMDGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenPMDGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: OpenPMDGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenPMDGeneralPluginInfo::GetID() const
{
    return "OpenPMD_1.0";
}
// ****************************************************************************
//  Method: OpenPMDGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OpenPMDGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: OpenPMDGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OpenPMDGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  OpenPMDGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a OpenPMD database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
OpenPMDGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.pmd");
    defaultPatterns.push_back("*.opmd");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  OpenPMDGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a OpenPMD database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OpenPMDGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  OpenPMDGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the OpenPMD plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OpenPMDGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
