// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OpenEXRPluginInfo.C
// ****************************************************************************

#include <OpenEXRPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(OpenEXR,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(OpenEXR,General)

// ****************************************************************************
//  Method: OpenEXRGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenEXRGeneralPluginInfo::GetName() const
{
    return "OpenEXR";
}

// ****************************************************************************
//  Method: OpenEXRGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenEXRGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: OpenEXRGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OpenEXRGeneralPluginInfo::GetID() const
{
    return "OpenEXR_1.0";
}
// ****************************************************************************
//  Method: OpenEXRGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OpenEXRGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: OpenEXRGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OpenEXRGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  OpenEXRGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a OpenEXR database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
OpenEXRGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.exr");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  OpenEXRGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a OpenEXR database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OpenEXRGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  OpenEXRGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the OpenEXR plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OpenEXRGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
