// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OVERFLOWPluginInfo.C
// ****************************************************************************

#include <OVERFLOWPluginInfo.h>

#include <visit-config.h>

#ifdef OVERFLOW
#undef OVERFLOW
#endif
VISIT_PLUGIN_VERSION(OVERFLOW,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(OVERFLOW,General)

// ****************************************************************************
//  Method: OVERFLOWGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OVERFLOWGeneralPluginInfo::GetName() const
{
    return "OVERFLOW";
}

// ****************************************************************************
//  Method: OVERFLOWGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OVERFLOWGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: OVERFLOWGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OVERFLOWGeneralPluginInfo::GetID() const
{
    return "OVERFLOW_1.0";
}
// ****************************************************************************
//  Method: OVERFLOWGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OVERFLOWGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: OVERFLOWGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OVERFLOWGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  OVERFLOWGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a OVERFLOW database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
OVERFLOWGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.dat");
    defaultPatterns.push_back("*.save");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  OVERFLOWGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a OVERFLOW database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OVERFLOWGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  OVERFLOWGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the OVERFLOW plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
OVERFLOWGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
