// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: NektarPPPluginInfo.C
// ****************************************************************************

#include <NektarPPPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(NektarPP,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(NektarPP,General)

// ****************************************************************************
//  Method: NektarPPGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NektarPPGeneralPluginInfo::GetName() const
{
    return "NektarPP";
}

// ****************************************************************************
//  Method: NektarPPGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NektarPPGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: NektarPPGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NektarPPGeneralPluginInfo::GetID() const
{
    return "NektarPP_1.0";
}
// ****************************************************************************
//  Method: NektarPPGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
NektarPPGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: NektarPPGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
NektarPPGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  NektarPPGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a NektarPP database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
NektarPPGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.chk");
    defaultPatterns.push_back("*.fld");
    defaultPatterns.push_back("*.xml");
    defaultPatterns.push_back("*.rst");
    defaultPatterns.push_back("*.bse");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  NektarPPGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a NektarPP database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
NektarPPGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  NektarPPGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the NektarPP plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
NektarPPGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
