// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <NETCDFPluginInfo.h>
#include <avtNETCDFFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  NETCDFCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a NETCDF database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
NETCDFCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method: NETCDFCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a NETCDF database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A NETCDF database from list.
//
//  Programmer: Brad Whitlock
//  Creation:   Fri Aug 12 09:46:51 PDT 2005
//
//  Modifications:
//    Brad Whitlock, Fri Dec 9 17:39:34 PST 2005
//    I renamed a method call.
//
// ****************************************************************************

avtDatabase *
NETCDFCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtDatabase *db = 0;

    //
    // Create a file format interface.
    //
    avtFileFormatInterface *ffi = NETCDF_CreateFileFormatInterface(list,
                                                                   nList,
                                                                   nBlock);

    //
    // If we created a file format interface, try creating a database.
    //
    if(ffi)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(ffi);
        }
        CATCH(VisItException)
        {
            delete ffi;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;
}

