// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtMRTestFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_MRTest_FILE_FORMAT_H
#define AVT_MRTest_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>

class avtMultiresSelection;

// ****************************************************************************
//  Class: avtMRTestFileFormat
//
//  Purpose:
//      A simple example of a multi resolution file reader.
//
//  Programmer: brugger -- generated by xml2avt
//  Creation:   Fri Dec 20 12:20:07 PDT 2013
//
//  Modifications:
//    Eric Brugger, Wed Jan  8 17:08:02 PST 2014
//    I modified the reader to also create 3d meshes.
//
// ****************************************************************************

class avtMRTestFileFormat : public avtSTMDFileFormat
{
  public:
                           avtMRTestFileFormat(const char *);
    virtual               ~avtMRTestFileFormat();

    virtual const char    *GetType(void)   { return "MRTest File Format"; };

    virtual bool           CanCacheVariable(const char *var);

    virtual void           RegisterDataSelections(
                               const std::vector<avtDataSelection_p> &sels,
                               std::vector<bool> *selsApplied);

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);

  protected:
    std::string            filename;

    int                    meshNx, meshNy, meshNz;
    double                 meshXmin, meshXmax, meshYmin, meshYmax,
                           meshZmin, meshZmax;
    int                    coarseNx, coarseNy, coarseNz;
    int                    maxLevel2d, maxLevel3d;

    std::vector<avtDataSelection_p>  selectionsList;
    std::vector<bool>               *selectionsApplied;

    avtMultiresSelection  *selection;
    double                 transformMatrix[16];
    double                 cellArea;

    void                   GetSelection();

    void                   CalculateMesh2d(double &, double &,
                               double &, double &, int &, int &);
    void                   CalculateMesh3d(double &, double &,
                               double &, double &, double &, double &,
                               int &, int &, int &);

    vtkDataSet            *GetMesh2d();
    vtkDataSet            *GetMesh3d();

    vtkDataArray          *GetVar2d();
    vtkDataArray          *GetVar3d();
};


#endif
