// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtMOABWriter.h                              //
// ************************************************************************* //

#ifndef AVT_MOAB_WRITER_H
#define AVT_MOAB_WRITER_H

#include <avtDatabaseWriter.h>

#include <vector>
#include <string>

class DBOptionsAttributes;

namespace moab
{
  class Core;
}

// ****************************************************************************
//  Class: avtMOABWriter
//
//  Purpose:
//      A module that writes out MOAB files.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

class
avtMOABWriter : public avtDatabaseWriter
{
  public:
                   avtMOABWriter(DBOptionsAttributes *);
    virtual       ~avtMOABWriter() {;};

  protected:
    std::string    stem;

    virtual void   OpenFile(const std::string &, int nb);
    virtual void   WriteHeaders(const avtDatabaseMetaData *, 
                                const std::vector<std::string>&,
                                const std::vector<std::string>&,
                                const std::vector<std::string>&);
    virtual void   WriteChunk(vtkDataSet *, int);
    virtual void   CloseFile(void);

    // DATA MEMBERS
    moab::Core*    mbCore;
};


#endif
