// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                              avtMOABWriter.C                             //
// ************************************************************************* //

#include <avtMOABWriter.h>

#include <vector>

#include <vtkDataSetWriter.h>

#include <avtDatabaseMetaData.h>
#include <DBOptionsAttributes.h>

// MOAB includes
#include <moab/Core.hpp>

using     std::string;
using     std::vector;


// ****************************************************************************
//  Method: avtMOABWriter constructor
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

avtMOABWriter::avtMOABWriter(DBOptionsAttributes *)
{
}

// ****************************************************************************
//  Method: avtMOABWriter::OpenFile
//
//  Purpose:
//      Does no actual work.  Just records the stem name for the files.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

void
avtMOABWriter::OpenFile(const string &stemname, int numblocks)
{
    stem = stemname;
}


// ****************************************************************************
//  Method: avtMOABWriter::WriteHeaders
//
//  Purpose:
//      Writes out a VisIt file to tie the MOAB files together.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

void
avtMOABWriter::WriteHeaders(const avtDatabaseMetaData *md, 
                            const std::vector<std::string>& scalars,
                            const std::vector<std::string>& vectors,
                            const std::vector<std::string>& materials)
{
    // WRITE OUT HEADER INFO
    mbCore->print_database();
}


// ****************************************************************************
//  Method: avtMOABWriter::WriteChunk
//
//  Purpose:
//      This writes out one chunk of an avtDataset.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

void
avtMOABWriter::WriteChunk(vtkDataSet *ds, int chunk)
{
    // WRITE OUT THIS ONE CHUNK
}


// ****************************************************************************
//  Method: avtMOABWriter::CloseFile
//
//  Purpose:
//      Closes the file.  This does nothing in this case.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

void
avtMOABWriter::CloseFile(void)
{
    // CLOSE FILES
}
