// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <MOABPluginInfo.h>
#include <avtMOABFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtMOABOptions.h>

// ****************************************************************************
//  Method:  MOABCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a MOAB database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
MOABCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method: MOABCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a MOAB database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A MOAB database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
MOABCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0; i < nList; i++)
    {
        ffl[i] = new avtMOABFileFormat(list[i], readOptions);
    }
    avtSTMDFileFormatInterface *inter
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: MOABCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
MOABCommonPluginInfo::GetReadOptions() const
{
    return GetMOABReadOptions();
}

// ****************************************************************************
//  Method: MOABCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
MOABCommonPluginInfo::GetWriteOptions() const
{
    return GetMOABWriteOptions();
}

