// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtMDSplusFileFormat.h                         //
// ************************************************************************* //

#ifndef AVT_MDSplus_FILE_FORMAT_H
#define AVT_MDSplus_FILE_FORMAT_H

#include <avtMTSDFileFormat.h>

#include <mdslib.h>

#include <vector>

class DBOptionsAttributes;


// ****************************************************************************
//  Class: avtMDSplusFileFormat
//
//  Purpose:
//      Reads in MDSplus files as a plugin to VisIt.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Wed Aug 11 13:45:13 PST 2010
//
// ****************************************************************************

class avtMDSplusFileFormat : public avtMTSDFileFormat
{
  public:
               avtMDSplusFileFormat(const char *, DBOptionsAttributes *);
    virtual   ~avtMDSplusFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep, 
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    virtual void        GetCycles(std::vector<int> &);
    virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "MDSplus"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    void LoadFile();

    // DATA MEMBERS
    std::string m_host;
    std::string m_tree;
    int         m_shot;
    std::string m_signal;
    std::string m_mesh;

    int m_socket;

    std::vector<int>    m_cycles;
    std::vector<double> m_times;

    std::vector<std::string> m_fieldVarNames;

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
};


#endif
